/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.data.manipulation.impl;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.data.manipulation.api.ResourcePackInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourcePackHook {
    private static final List<ResourcePackInterceptor> INTERCEPTORS = FabricLoader.getInstance().getEntrypoints("libjf:resource_pack_interceptor", ResourcePackInterceptor.class).stream().toList();

    public static class_7367<InputStream> hookOpenRoot(class_7367<InputStream> value, class_3262 pack, String[] fileName) {
        for (ResourcePackInterceptor interceptor : INTERCEPTORS) {
            value = interceptor.openRoot(fileName, value, pack);
        }
        return value;
    }

    public static class_7367<InputStream> hookOpen(class_7367<InputStream> value, class_3262 pack, class_3264 type, class_2960 id) {
        for (ResourcePackInterceptor interceptor : INTERCEPTORS) {
            value = interceptor.open(type, id, value, pack);
        }
        return value;
    }

    public static class_3262.class_7664 hookFindResources(class_3262 pack, class_3264 type, String namespace, String prefix, class_3262.class_7664 target) {
        for (ResourcePackInterceptor interceptor : INTERCEPTORS.reversed()) {
            target = interceptor.findResources(type, namespace, prefix, target, pack);
        }
        return target;
    }

    public static <T> T hookParseMetadata(T value, class_3262 pack, class_7677<T> reader) throws IOException {
        LazySupplier lazy = new LazySupplier(value);
        for (ResourcePackInterceptor interceptor : INTERCEPTORS) {
            lazy = lazy.andThen(supplier -> {
                try {
                    return interceptor.parseMetadata(reader, supplier, pack);
                }
                catch (IOException e) {
                    LibJf.LOGGER.error("Could not call ResourcePack.OPEN_ROOT listener", (Throwable)e);
                    return null;
                }
            });
        }
        return (T)lazy.get();
    }

    public static <T> T hookParseMetadataEx(IOException ex, class_3262 pack, class_7677<T> reader) throws IOException {
        try {
            return ResourcePackHook.hookParseMetadata(null, pack, reader);
        }
        catch (Throwable t) {
            ex.addSuppressed(t);
            throw ex;
        }
    }
}

