/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.io;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.commons.serialize.json.JsonWriter;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.io.CommentProvider;
import io.gitlab.jfronny.libjf.config.impl.watch.JfConfigWatchService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;

public class DefaultConfigIO {
    public static Consumer<ConfigInstance> loader(String id) {
        return c -> c.getFilePath().ifPresent(path -> {
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedReader br = Files.newBufferedReader(path);
                     JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader((Reader)br);){
                    DefaultConfigIO.runActions(id, DefaultConfigIO.createActions(c), jr);
                }
                catch (Exception e) {
                    LibJf.LOGGER.error("Could not read config for " + id, (Throwable)e);
                }
            }
            c.write();
        });
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>> void runActions(String id, Map<String, Action> actions, Reader reader) {
        try {
            if (reader.peek() != Token.BEGIN_OBJECT) {
                LibJf.LOGGER.error("Invalid config: Not a JSON object for " + id, new Object[0]);
                reader.skipValue();
                return;
            }
            HashSet<String> appeared = new HashSet<String>();
            reader.beginObject();
            while (reader.peek() != Token.END_OBJECT) {
                String name2 = reader.nextName();
                SerializeReader view = reader.createView();
                try {
                    Action action2 = actions.get(name2);
                    if (action2 == null) {
                        LibJf.LOGGER.warn("Unrecognized key in config for " + id + ": " + name2, new Object[0]);
                        continue;
                    }
                    if (!appeared.add(name2)) {
                        LibJf.LOGGER.warn("Duplicate key in config for " + id + ": " + name2, new Object[0]);
                        continue;
                    }
                    action2.task.accept(view);
                }
                finally {
                    if (view == null) continue;
                    view.close();
                }
            }
            reader.endObject();
            actions.forEach((name, action) -> {
                if (action.required && !appeared.contains(name)) {
                    LibJf.LOGGER.error("Missing entry in config for " + id + ": " + name, new Object[0]);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not read config", e);
        }
    }

    private static Map<String, Action> createActions(ConfigCategory category) {
        HashMap actions = new HashMap();
        category.getEntries().forEach(entry -> actions.putIfAbsent(entry.getName(), new Action(reader -> {
            try {
                entry.loadFromJson(reader);
            }
            catch (Exception e) {
                LibJf.LOGGER.error("Could not set config entry value of " + entry.getName(), (Throwable)e);
            }
        })));
        category.getCategories().forEach((id, cat) -> {
            String innerId = category.getId() + "." + id;
            Map<String, Action> innerActions = DefaultConfigIO.createActions(cat);
            actions.putIfAbsent(id, new Action(reader -> DefaultConfigIO.runActions(innerId, innerActions, reader)));
        });
        if (category instanceof DslConfigCategory) {
            DslConfigCategory cat2 = (DslConfigCategory)category;
            cat2.migrations.forEach((id, migration) -> actions.putIfAbsent(id, new Action((Consumer<SerializeReader>)migration, false)));
        }
        return Map.copyOf(actions);
    }

    public static Consumer<ConfigInstance> writer(String id) {
        return c -> c.getFilePath().ifPresent(path -> JfConfigWatchService.lock(path, () -> {
            try (BufferedWriter bw = Files.newBufferedWriter(path, new OpenOption[0]);
                 JsonWriter jw = LibJf.LENIENT_TRANSPORT.createWriter((Writer)bw);){
                DefaultConfigIO.writeTo(jw, c, CommentProvider.Loader.INSTANCE.load(c.getId()));
            }
            catch (Exception e) {
                LibJf.LOGGER.error("Could not write config for " + id, (Throwable)e);
            }
        }));
    }

    private static void writeTo(JsonWriter writer, ConfigCategory category, CommentProvider comments) throws IOException {
        category.fix();
        String commentText = comments.description();
        if (commentText != null) {
            writer.comment(commentText);
        }
        writer.beginObject();
        for (EntryInfo<?> entryInfo : category.getEntries()) {
            try {
                entryInfo.writeTo(writer, comments.entry(entryInfo.getName()).tooltip());
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not write entry", (Throwable)e);
            }
        }
        for (Map.Entry entry : category.getCategories().entrySet()) {
            writer.name((String)entry.getKey());
            DefaultConfigIO.writeTo(writer, (ConfigCategory)entry.getValue(), comments.category((String)entry.getKey()));
        }
        writer.endObject();
    }

    record Action(Consumer<SerializeReader> task, boolean required) {
        public Action(Consumer<SerializeReader> task) {
            this(task, true);
        }
    }
}

