/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.Entry;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.dsl.NothingSerializedException;
import java.lang.reflect.Field;

public class DslEntryInfo<T>
implements EntryInfo<T> {
    private final String name;
    private final T defaultValue;
    private final ThrowingSupplier<T, IllegalAccessException> get;
    private final ThrowingConsumer<T, IllegalAccessException> set;
    private final Type type;
    private final int width;
    private final double minValue;
    private final double maxValue;

    public DslEntryInfo(String name, T defaultValue, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type, int width, double minValue, double maxValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.get = get;
        this.set = set;
        this.type = type;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DslEntryInfo(String name, T def, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type) {
        this(name, def, get, set, type, 100, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static DslEntryInfo<Object> ofField(Field field) {
        Entry entry = field.getAnnotation(Entry.class);
        Object defaultValue = null;
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new DslEntryInfo<Object>(field.getName(), defaultValue, () -> field.get(null), v -> field.set(null, v), Type.ofClass(field.getGenericType()), entry == null ? 100 : entry.width(), entry == null ? Double.NEGATIVE_INFINITY : entry.min(), entry == null ? Double.POSITIVE_INFINITY : entry.max());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T getValue() throws IllegalAccessException {
        return (T)this.get.get();
    }

    @Override
    public void setValue(T value) throws IllegalAccessException {
        this.set.accept(value);
    }

    @Override
    public Type getValueType() {
        return this.type;
    }

    @Override
    public void fix() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (IllegalAccessException e) {
            LibJf.LOGGER.error("Could not read value", (Throwable)e);
            return;
        }
        T valueOriginal = value;
        if (value instanceof Integer) {
            Integer v = (Integer)value;
            if ((double)v.intValue() < this.minValue) {
                value = (int)this.minValue;
            }
            if ((double)v.intValue() > this.maxValue) {
                value = (int)this.maxValue;
            }
        } else if (value instanceof Float) {
            Float v = (Float)value;
            if ((double)v.floatValue() < this.minValue) {
                value = Float.valueOf((float)this.minValue);
            }
            if ((double)v.floatValue() > this.maxValue) {
                value = Float.valueOf((float)this.maxValue);
            }
        } else if (value instanceof Double) {
            Double v = (Double)value;
            if (v < this.minValue) {
                value = this.minValue;
            }
            if (v > this.maxValue) {
                value = this.maxValue;
            }
        }
        if (valueOriginal != value) {
            try {
                this.setValue(this.cast(value));
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not write value", (Throwable)e);
            }
        }
    }

    @Override
    public <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>> T deserializeOneFrom(Reader reader) throws TEx, MalformedDataException {
        Token next = reader.peek();
        if (this.type.isBool()) {
            if (next == Token.BOOLEAN) {
                return this.cast(reader.nextBoolean());
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected boolean but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isString()) {
            if (next == Token.STRING || next == Token.NUMBER) {
                return this.cast(reader.nextString());
            }
            if (next == Token.BOOLEAN) {
                return this.cast(Boolean.toString(reader.nextBoolean()));
            }
            if (next == Token.NULL) {
                reader.nextNull();
                return this.cast(null);
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected string but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isInt()) {
            if (next == Token.NUMBER) {
                return this.cast(reader.nextInt());
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isLong()) {
            if (next == Token.NUMBER) {
                return this.cast(reader.nextLong());
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isDouble()) {
            if (next == Token.NUMBER) {
                return this.cast(reader.nextDouble());
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isFloat()) {
            if (next == Token.NUMBER) {
                return this.cast(Float.valueOf((float)reader.nextDouble()));
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected number but got " + String.valueOf(next), new Object[0]);
        } else if (this.type.isEnum()) {
            Type.TEnum e = (Type.TEnum)this.type;
            if (next == Token.STRING) {
                return this.cast(e.optionForString(reader.nextString()));
            }
            LibJf.LOGGER.error("Unexpected value for " + this.name + ": expected string but got " + String.valueOf(next), new Object[0]);
        } else {
            try {
                return this.cast(LibJf.MAPPER.getAdapter(this.type.asToken()).deserialize(reader));
            }
            catch (MalformedDataException e) {
                LibJf.LOGGER.error("Could not read " + this.name, (Throwable)e);
            }
        }
        throw new NothingSerializedException();
    }

    private T cast(Object object) {
        return (T)object;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }
}

