/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class DslConfigCategory
implements ConfigCategory {
    private final String id;
    private final List<EntryInfo<?>> entries;
    private final Map<String, Runnable> presets;
    private final List<Supplier<List<ConfigInstance>>> referencedConfigs;
    @ApiStatus.Internal
    public final Map<String, Consumer<SerializeReader>> migrations;
    private final Map<String, ConfigCategory> categories;
    private final Supplier<ConfigInstance> root;
    private final List<Consumer<ConfigCategory>> verifiers;

    public DslConfigCategory(String id, List<EntryInfo<?>> entries, Map<String, Consumer<ConfigCategory>> presets, List<Supplier<List<ConfigInstance>>> referencedConfigs, List<CategoryBuilder<?>> categories, Supplier<ConfigInstance> root, List<Consumer<ConfigCategory>> verifiers, Map<String, Consumer<SerializeReader>> migrations) {
        this.id = id;
        this.entries = entries;
        this.presets = presets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> () -> ((Consumer)t.getValue()).accept(this), (u, v) -> () -> {
            u.run();
            v.run();
        }, LinkedHashMap::new));
        this.referencedConfigs = referencedConfigs;
        this.migrations = migrations;
        this.categories = categories.stream().collect(Collectors.toMap(CategoryBuilder::getId, b -> b.build(root), (u, v) -> v, LinkedHashMap::new));
        this.root = root;
        this.verifiers = verifiers;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<EntryInfo<?>> getEntries() {
        return this.entries;
    }

    @Override
    public Map<String, Runnable> getPresets() {
        return this.presets;
    }

    @Override
    public List<ConfigInstance> getReferencedConfigs() {
        return this.referencedConfigs.stream().map(Supplier::get).mapMulti(Iterable::forEach).toList();
    }

    @Override
    public Map<String, ConfigCategory> getCategories() {
        return this.categories;
    }

    @Override
    public ConfigInstance getRoot() {
        return this.root.get();
    }

    @Override
    public void fix() {
        ConfigCategory.super.fix();
        for (Consumer<ConfigCategory> verifier : this.verifiers) {
            verifier.accept(this);
        }
    }
}

