/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.api.v2;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslEntryInfo;
import io.gitlab.jfronny.libjf.config.impl.dsl.NothingSerializedException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface EntryInfo<T> {
    public static EntryInfo<?> ofField(Field field) {
        return DslEntryInfo.ofField(field);
    }

    @ApiStatus.Internal
    public static EntryInfo<?> ofField(Class<?> klazz, String name) {
        try {
            return EntryInfo.ofField(klazz.getField(name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName();

    public T getDefault();

    public T getValue() throws IllegalAccessException;

    public void setValue(T var1) throws IllegalAccessException;

    public Type getValueType();

    default public boolean supportsRepresentation() {
        return true;
    }

    public void fix();

    default public <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>> void loadFromJson(Reader reader) throws TEx, IllegalAccessException {
        try {
            this.setValue(this.deserializeOneFrom(reader));
        }
        catch (MalformedDataException e) {
            LibJf.LOGGER.error("Could not read " + this.getName(), (Throwable)e);
        }
        catch (NothingSerializedException nothingSerializedException) {
            // empty catch block
        }
    }

    default public <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>> void writeTo(Writer writer, @Nullable String comment) throws TEx, IllegalAccessException {
        try {
            if (comment != null) {
                writer.comment(comment);
            }
            if (this.getValueType().isEnum()) {
                writer.comment("Valid: [" + Arrays.stream(this.getValueType().asEnum().options()).map(Objects::toString).collect(Collectors.joining(", ")) + "]");
            }
            writer.name(this.getName());
            this.serializeOneTo(this.getValue(), writer);
        }
        catch (MalformedDataException e) {
            LibJf.LOGGER.error("Could not write " + this.getName(), (Throwable)e);
        }
    }

    default public <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>> T deserializeOneFrom(Reader reader) throws TEx, MalformedDataException {
        return (T)LibJf.MAPPER.getAdapter(this.getTypeToken()).deserialize(reader);
    }

    default public <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>> void serializeOneTo(T value, Writer writer) throws TEx, MalformedDataException {
        LibJf.MAPPER.getAdapter(this.getTypeToken()).serialize(value, writer);
    }

    default public TypeToken<T> getTypeToken() {
        return Objects.requireNonNullElse(this.getValueType().asToken(), TypeToken.get(String.class));
    }

    public int getWidth();

    public double getMinValue();

    public double getMaxValue();

    default public void reset() throws IllegalAccessException {
        this.setValue(this.getDefault());
    }
}

