/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.mixin;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.util.ClientUtil;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.events.client.ClientEmoteEvents;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class EmotePlayerMixin
extends class_1657
implements IPlayerEntity {
    @Unique
    private int emotecraft$age = 0;
    @Unique
    private final EmotePlayer emotecraft$container = new EmotePlayer((class_742)this);
    @Unique
    private boolean emotecraft$isForced = false;

    public EmotePlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_638 clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        ((IAnimatedPlayer)this).playerAnimLib$getAnimManager().addAnimLayer(1000, (IAnimation)this.emotecraft$container);
    }

    @Override
    public void emotecraft$playEmote(@Nullable Animation emote, float tick, boolean isForced) {
        this.stopEmote();
        if (emote != null) {
            this.emotecraft$container.triggerAnimation(emote, tick);
            this.initEmotePerspective();
            if (this.isMainPlayer()) {
                this.emotecraft$isForced = isForced;
            }
        }
    }

    @Override
    @NotNull
    public EmotePlayer emotecraft$getEmote() {
        return this.emotecraft$container;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.emotecraft$age <= 1 && this.emotecraft$age++ == 1) {
            Pair<Animation, Float> p = ClientEmotePlay.getEmoteForUUID(this.method_5667());
            if (p != null) {
                ((ClientEmoteEvents.EmotePlayEvent)ClientEmoteEvents.EMOTE_PLAY.invoker()).onEmotePlay((Animation)p.left(), ((Float)p.right()).floatValue(), this.method_5667());
                this.emotecraft$playEmote((Animation)p.left(), ((Float)p.right()).floatValue(), false);
            }
            if (!this.isMainPlayer() && ClientUtil.getClientPlayer() != null && ClientUtil.getClientPlayer().isPlayingEmote()) {
                class_746 playerEntity = ClientUtil.getClientPlayer();
                ClientEmotePlay.clientRepeatLocalEmote(playerEntity.emotecraft$getEmote().getCurrentAnimationInstance(), playerEntity.emotecraft$getEmote().getAnimationTicks(), this.method_5667());
            }
        }
        if (this.isPlayingEmote() && this.isMainPlayer()) {
            if (this.emotecraft$getEmote().perspective && PlatformTools.getPerspective() != PlatformTools.getConfig().getCameraType()) {
                this.emotecraft$getEmote().perspective = false;
            }
            if (!EmoteHolder.canRunEmote((class_742)this)) {
                ClientEmotePlay.clientStopLocalEmote(this.emotecraft$getEmote().getCurrentAnimationInstance());
            }
        }
    }

    @Override
    public boolean emotecraft$isForcedEmote() {
        return this.isPlayingEmote() && this.emotecraft$isForced;
    }
}

