/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.entrywidgets.impl;

import java.util.Deque;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ScopedValue<T> {
    private final InheritableThreadLocal<Carrier<T>> value = new InheritableThreadLocal<Carrier<T>>(this){

        @Override
        protected Carrier<T> childValue(Carrier<T> parentValue) {
            return new Carrier(parentValue);
        }

        @Override
        protected Carrier<T> initialValue() {
            return new Carrier();
        }
    };

    public static <T> void runWhere(ScopedValue<T> key, T value, Runnable op) {
        ((Carrier)key.value.get()).setValue(value);
        try {
            op.run();
        }
        finally {
            ((Carrier)key.value.get()).clear();
        }
    }

    public T orElse(T other) {
        return ((Carrier)this.value.get()).orElse(other);
    }

    @Environment(value=EnvType.CLIENT)
    private static class Carrier<T> {
        private final Deque<T> value = new LinkedList<T>();
        private final Carrier<T> parent;

        public Carrier() {
            this(null);
        }

        public Carrier(Carrier<T> parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(T value) {
            Deque<T> deque = this.value;
            synchronized (deque) {
                this.value.push(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Deque<T> deque = this.value;
            synchronized (deque) {
                this.value.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T orElse(T other) {
            Deque<T> deque = this.value;
            synchronized (deque) {
                if (!this.value.isEmpty()) {
                    return this.value.peek();
                }
                if (this.parent == null) {
                    return other;
                }
                return this.parent.orElse(other);
            }
        }
    }
}

