/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network.rci.entry;

import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.network.rci.MirrorConfigCategory;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.MirrorEntryInfoBase;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;

public class MirrorEntryInfo<T>
extends MirrorEntryInfoBase<T> {
    private final T defaultValue;
    private final Type valueType;
    private final int width;
    private final double minValue;
    private final double maxValue;

    public MirrorEntryInfo(PacketSender packetSender, MirrorConfigCategory category, String entryName, T defaultValue, Type valueType, int width, double minValue, double maxValue) {
        super(packetSender, category, entryName);
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public static Object read(class_2540 buf, Type type) {
        if (!buf.readBoolean()) {
            return null;
        }
        if (type.isInt()) {
            return buf.readInt();
        }
        if (type.isLong()) {
            return buf.readLong();
        }
        if (type.isFloat()) {
            return Float.valueOf(buf.readFloat());
        }
        if (type.isDouble()) {
            return buf.readDouble();
        }
        if (type.isString()) {
            return buf.method_19772();
        }
        if (type.isBool()) {
            return buf.readBoolean();
        }
        if (type.isEnum()) {
            return type.asEnum().optionForString(buf.method_19772());
        }
        throw new UnsupportedOperationException();
    }

    public static void write(class_2540 buf, Type type, Object data) {
        if (data == null) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            if (type.isInt()) {
                buf.method_53002(((Integer)data).intValue());
            } else if (type.isLong()) {
                buf.method_52974(((Long)data).longValue());
            } else if (type.isFloat()) {
                buf.method_52941(((Float)data).floatValue());
            } else if (type.isDouble()) {
                buf.method_52940(((Double)data).doubleValue());
            } else if (type.isString()) {
                buf.method_10814((String)data);
            } else if (type.isBool()) {
                buf.method_52964(((Boolean)data).booleanValue());
            } else if (type.isEnum()) {
                buf.method_10814(data.toString());
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public T getValue() {
        class_2540 buf = PacketByteBufs.create();
        this.writePath(buf);
        buf = this.sendRequest("getEntryValue", buf);
        return (T)MirrorEntryInfo.read(buf, this.valueType);
    }

    public void setValue(T value) {
        class_2540 buf = PacketByteBufs.create();
        this.writePath(buf);
        MirrorEntryInfo.write(buf, this.valueType, value);
        this.sendRequest("setEntryValue", buf);
    }
}

