/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network.rci;

import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.network.rci.MirrorConfigInstance;
import io.gitlab.jfronny.libjf.config.impl.network.rci.MirrorObject;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.Datatype;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.MirrorEntryInfo;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.MirrorEntryInfoUnsupported;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;

public class MirrorConfigCategory
extends MirrorObject
implements ConfigCategory {
    protected final String id;
    protected final String categoryPath;
    protected final Supplier<MirrorConfigInstance> root;

    public MirrorConfigCategory(PacketSender packetSender, String id, String categoryPath, Supplier<MirrorConfigInstance> root) {
        super(packetSender);
        this.id = id;
        this.categoryPath = categoryPath;
        this.root = root;
    }

    public String getId() {
        return this.id;
    }

    public void writeCategoryPath(class_2540 buf) {
        this.root.get().writeConfigInstance(buf);
        buf.method_34062(this.getCategoryPathList(), class_2540::method_10814);
    }

    protected List<String> getCategoryPathList() {
        if (this.categoryPath.isEmpty()) {
            return List.of();
        }
        String[] sc = this.categoryPath.split("\\.");
        return Arrays.stream(sc).toList();
    }

    public List<EntryInfo<?>> getEntries() {
        class_2540 buf = PacketByteBufs.create();
        this.writeCategoryPath(buf);
        buf = this.sendRequest("getEntries", buf);
        return List.copyOf(buf.method_34066(b -> {
            String name = b.method_19772();
            int type = b.readInt();
            if (type == -1) {
                return new MirrorEntryInfoUnsupported(this.packetSender, this, name);
            }
            Type.TInt t = switch (Datatype.values()[type]) {
                default -> throw new MatchException(null, null);
                case Datatype.INT -> Type.TInt.INSTANCE;
                case Datatype.LONG -> Type.TLong.INSTANCE;
                case Datatype.FLOAT -> Type.TFloat.INSTANCE;
                case Datatype.DOUBLE -> Type.TDouble.INSTANCE;
                case Datatype.STRING -> Type.TString.INSTANCE;
                case Datatype.BOOL -> Type.TBool.INSTANCE;
                case Datatype.ENUM -> Type.TEnum.create((String)name, (String[])((String[])b.method_34066(class_2540::method_19772).toArray(String[]::new)));
            };
            return new MirrorEntryInfo<Object>(this.packetSender, this, name, MirrorEntryInfo.read(b, (Type)t), (Type)t, b.readInt(), b.readDouble(), b.readDouble());
        }));
    }

    public Map<String, Runnable> getPresets() {
        class_2540 buf = PacketByteBufs.create();
        this.writeCategoryPath(buf);
        buf = this.sendRequest("getPresets", buf);
        return buf.method_34066(class_2540::method_19772).stream().collect(Collectors.toUnmodifiableMap(Function.identity(), s -> () -> this.runPreset((String)s)));
    }

    private void runPreset(String id) {
        class_2540 buf = PacketByteBufs.create();
        this.writeCategoryPath(buf);
        buf.method_10814(id);
        this.sendRequest("runPreset", buf);
    }

    public List<ConfigInstance> getReferencedConfigs() {
        class_2540 buf = PacketByteBufs.create();
        this.writeCategoryPath(buf);
        buf = this.sendRequest("getReferencedConfigs", buf);
        return buf.method_34066(b -> b.readBoolean() ? MirrorConfigInstance.create(this.packetSender, b.method_19772()) : MirrorConfigInstance.create(this.packetSender, b.method_19772(), Stream.concat(this.root.get().streamParentPaths(), Stream.of(Stream.concat(Stream.of(this.root.get().getId()), this.getCategoryPathList().stream()).toList())).toList()));
    }

    public Map<String, ConfigCategory> getCategories() {
        class_2540 buf = PacketByteBufs.create();
        this.writeCategoryPath(buf);
        buf = this.sendRequest("getCategories", buf);
        return buf.method_34066(class_2540::method_19772).stream().collect(Collectors.toUnmodifiableMap(Function.identity(), s -> new MirrorConfigCategory(this.packetSender, (String)s, this.categoryPath + s + ".", this.root)));
    }

    public ConfigInstance getRoot() {
        return this.root.get();
    }
}

