/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network;

import io.gitlab.jfronny.libjf.config.impl.network.PermissionDeniedException;
import io.gitlab.jfronny.libjf.config.impl.network.ResponseHandler;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2540;

public record PMResponseHandler(Consumer<Response> handler) implements ResponseHandler
{
    public PMResponseHandler {
        Objects.requireNonNull(handler);
    }

    @Override
    public void onSuccess(class_2540 buf) {
        this.handler.accept(new Response.Success(buf));
    }

    @Override
    public void onDeny() {
        this.handler.accept(Response.SimpleFailure.DENY);
    }

    @Override
    public void onNotFound() {
        this.handler.accept(Response.SimpleFailure.NOT_FOUND);
    }

    @Override
    public void onFailure(String message) {
        this.handler.accept(new Response.Failure(message));
    }

    public static sealed interface Response {
        public class_2540 get();

        public record Failure(String message) implements Response
        {
            public Failure {
                Objects.requireNonNull(message);
            }

            @Override
            public class_2540 get() {
                throw new RuntimeException(this.message);
            }
        }

        public static enum SimpleFailure implements Response
        {
            DENY,
            NOT_FOUND;


            @Override
            public class_2540 get() {
                if (this == DENY) {
                    throw new PermissionDeniedException("Access not allowed");
                }
                throw new UnsupportedOperationException("Method not found");
            }
        }

        public record Success(class_2540 buf) implements Response
        {
            @Override
            public class_2540 get() {
                return this.buf;
            }
        }
    }
}

