/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

public class IndentingStringBuilder {
    private final StringBuilder builder;
    private final String indent;

    public IndentingStringBuilder() {
        this.builder = new StringBuilder();
        this.indent = "";
    }

    public IndentingStringBuilder(StringBuilder builder, String indent) {
        this.builder = builder;
        this.indent = indent;
    }

    public String toString() {
        if (this.builder.isEmpty()) {
            return "";
        }
        return this.builder.substring(1);
    }

    public IndentingStringBuilder line(String content) {
        this.builder.append('\n').append(this.indent).append(content.replace("\n", "\n" + this.indent));
        return this;
    }

    public IndentingStringBuilder indent() {
        return new IndentingStringBuilder(this.builder, this.indent + "    ");
    }
}

