/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.serialization;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializerFor;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedReader;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedWriter;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBooleanEntry;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEnumEntry;
import io.gitlab.jfronny.respackopts.model.tree.ConfigNumericEntry;
import io.gitlab.jfronny.respackopts.model.tree.ConfigStringEntry;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigBooleanEntry;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigBranch;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigEnumEntry;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigNumericEntry;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigStringEntry;
import io.gitlab.jfronny.respackopts.serialization.entry.BooleanEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.serialization.entry.EnumEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.serialization.entry.NumericEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.serialization.entry.StringEntryTypeAdapter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

@SerializerFor(targets={ConfigEntry.class})
public class ConfigEntryTypeAdapter
extends TypeAdapter<ConfigEntry<?>> {
    public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(ConfigEntry<?> entry, Writer writer) throws TEx, MalformedDataException {
        ConfigEntry<?> configEntry = entry;
        Objects.requireNonNull(configEntry);
        ConfigEntry<?> configEntry2 = configEntry;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfigBooleanEntry.class, ConfigNumericEntry.class, ConfigEnumEntry.class, ConfigBranch.class, ConfigStringEntry.class}, configEntry2, n)) {
            case 0: {
                ConfigBooleanEntry bl = (ConfigBooleanEntry)configEntry2;
                GC_ConfigBooleanEntry.serialize(bl, writer);
                break;
            }
            case 1: {
                ConfigNumericEntry num = (ConfigNumericEntry)configEntry2;
                GC_ConfigNumericEntry.serialize(num, writer);
                break;
            }
            case 2: {
                ConfigEnumEntry en = (ConfigEnumEntry)configEntry2;
                GC_ConfigEnumEntry.serialize(en, writer);
                break;
            }
            case 3: {
                ConfigBranch br = (ConfigBranch)configEntry2;
                GC_ConfigBranch.serialize(br, writer);
                break;
            }
            case 4: {
                ConfigStringEntry str = (ConfigStringEntry)configEntry2;
                GC_ConfigStringEntry.serialize(str, writer);
                break;
            }
            default: {
                throw new MalformedDataException("Unknown entry type: " + entry.getClass().getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> ConfigEntry<?> deserialize(Reader reader) throws TEx, MalformedDataException {
        switch (reader.peek()) {
            case BOOLEAN: {
                ConfigBooleanEntry configBooleanEntry;
                ConfigEntry configEntry = configBooleanEntry = GC_ConfigBooleanEntry.deserialize(reader);
                return configEntry;
            }
            case NUMBER: {
                ConfigNumericEntry configNumericEntry = GC_ConfigNumericEntry.deserialize(reader);
                ConfigEntry configEntry = configNumericEntry;
                return configEntry;
            }
            case STRING: 
            case BEGIN_ARRAY: {
                ConfigEnumEntry configEnumEntry = GC_ConfigEnumEntry.deserialize(reader);
                ConfigEntry configEntry = configEnumEntry;
                return configEntry;
            }
            case BEGIN_OBJECT: {
                void var3_18;
                DataElement.Object de;
                String type = null;
                reader.beginObject();
                try (EmulatedWriter ew = new EmulatedWriter();){
                    ew.beginObject();
                    while (reader.hasNext()) {
                        String key = reader.nextName();
                        ew.name(key);
                        if (key.equals("type")) {
                            type = reader.nextString();
                            ew.value(type);
                            continue;
                        }
                        reader.copyTo((SerializeWriter)ew);
                    }
                    ew.endObject();
                    de = (DataElement.Object)ew.get();
                }
                reader.endObject();
                if (type != null) {
                    if (BooleanEntryTypeAdapter.TYPES.contains(type)) {
                        ConfigBooleanEntry configBooleanEntry = GC_ConfigBooleanEntry.deserialize(new EmulatedReader((DataElement)de));
                    } else if (NumericEntryTypeAdapter.TYPES.contains(type)) {
                        ConfigNumericEntry e = GC_ConfigNumericEntry.deserialize(new EmulatedReader((DataElement)de));
                        ConfigNumericEntry configNumericEntry = NumericEntryTypeAdapter.INT_TYPES.contains(type) ? e.asInteger() : e;
                    } else if (EnumEntryTypeAdapter.TYPES.contains(type)) {
                        ConfigEnumEntry configEnumEntry = GC_ConfigEnumEntry.deserialize(new EmulatedReader((DataElement)de));
                    } else {
                        if (!StringEntryTypeAdapter.TYPES.contains(type)) throw new MalformedDataException("Invalid type for entry: " + type);
                        ConfigStringEntry configStringEntry = GC_ConfigStringEntry.deserialize(new EmulatedReader((DataElement)de));
                    }
                } else if (de.members().keySet().stream().allMatch(k -> "default".equals(k) || "min".equals(k) || "max".equals(k))) {
                    Respackopts.LOGGER.info("No \"type\" property for non-branch entry object, assuming slider", new Object[0]);
                    ConfigNumericEntry configNumericEntry = GC_ConfigNumericEntry.deserialize(new EmulatedReader((DataElement)de));
                } else {
                    ConfigBranch configBranch = GC_ConfigBranch.deserialize(new EmulatedReader((DataElement)de));
                }
                void var2_5 = var3_18;
                ConfigEntry configEntry = var2_5;
                return configEntry;
            }
            case NULL: {
                throw new MalformedDataException("Unexpected null value for entry");
            }
            default: {
                throw new MalformedDataException("Invalid data type for entry");
            }
        }
    }
}

