/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.serialization;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializerFor;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.muscript.ast.BoolExpr;
import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.bool.And;
import io.gitlab.jfronny.muscript.ast.bool.Not;
import io.gitlab.jfronny.muscript.ast.bool.Or;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.Equals;
import io.gitlab.jfronny.muscript.ast.dynamic.Get;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.respackopts.serialization.AttachmentHolder;
import io.gitlab.jfronny.respackopts.serialization.ExprTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@SerializerFor(targets={BoolExpr.class})
public class BoolExprTypeAdapter
extends TypeAdapter<BoolExpr> {
    public static final BoolExprTypeAdapter INSTANCE = new BoolExprTypeAdapter();

    public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> BoolExpr deserialize(Reader reader) throws TEx, MalformedDataException {
        if (AttachmentHolder.getAttachedVersion() > 7) {
            return ExprUtils.asBool((Expr)ExprTypeAdapter.INSTANCE.deserialize(reader));
        }
        return switch (reader.peek()) {
            case Token.BEGIN_OBJECT -> {
                reader.beginObject();
                if (reader.hasNext()) {
                    String key = reader.nextName();
                    Not v0 = switch (key.toLowerCase(Locale.ROOT)) {
                        case "and", "add", "&" -> this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.And);
                        case "==", "=", "equal", "eq" -> this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.EqualEqual);
                        case "not", "nor", "!" -> new Not(CodeLocation.NONE, this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.Or));
                        case "or", "|" -> this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.Or);
                        case "^", "xor" -> this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.BangEqual);
                        default -> throw new MalformedDataException("Unknown condition type: " + key);
                    };
                    Not expr = v0;
                    reader.endObject();
                    yield expr;
                }
                reader.endObject();
                throw new MalformedDataException("Empty condition object");
            }
            case Token.BEGIN_ARRAY -> this.merge(reader, io.gitlab.jfronny.muscript.parser.lexer.Token.And);
            case Token.STRING -> {
                String name = reader.nextString();
                if (name.toLowerCase(Locale.ROOT).equals("true")) {
                    yield Expr.literal((CodeLocation)CodeLocation.NONE, (boolean)true);
                }
                if (name.toLowerCase(Locale.ROOT).equals("false")) {
                    yield Expr.literal((CodeLocation)CodeLocation.NONE, (boolean)false);
                }
                yield this.rpoBooleanCondition(name);
            }
            case Token.BOOLEAN -> Expr.literal((CodeLocation)CodeLocation.NONE, (boolean)reader.nextBoolean());
            default -> throw new MalformedDataException("Invalid data type for condition");
        };
    }

    private <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> BoolExpr merge(Reader source, io.gitlab.jfronny.muscript.parser.lexer.Token token) throws TEx, MalformedDataException {
        if (token == io.gitlab.jfronny.muscript.parser.lexer.Token.BangEqual) {
            return new Not(CodeLocation.NONE, this.merge(source, io.gitlab.jfronny.muscript.parser.lexer.Token.EqualEqual));
        }
        ArrayList<BoolExpr> expressions = new ArrayList<BoolExpr>();
        if (source.peek() == Token.BEGIN_ARRAY) {
            source.beginArray();
            while (source.hasNext()) {
                expressions.add(this.deserialize(source));
            }
            source.endArray();
        } else {
            expressions.add(this.deserialize(source));
        }
        BoolExpr current = (BoolExpr)expressions.getFirst();
        for (BoolExpr expr : expressions.subList(1, expressions.size())) {
            current = switch (token) {
                case io.gitlab.jfronny.muscript.parser.lexer.Token.EqualEqual -> new Equals(CodeLocation.NONE, (Expr)current, (Expr)expr);
                case io.gitlab.jfronny.muscript.parser.lexer.Token.And -> new And(CodeLocation.NONE, current, expr);
                case io.gitlab.jfronny.muscript.parser.lexer.Token.Or -> new Or(CodeLocation.NONE, current, expr);
                default -> throw new IllegalArgumentException();
            };
        }
        return current;
    }

    private BoolExpr rpoBooleanCondition(String name) throws MalformedDataException {
        if (name.startsWith("modversion:")) {
            String code = name.substring("modversion:".length());
            String mod = code.substring(0, code.indexOf(58));
            String predicate = code.substring(code.indexOf(58) + 1);
            return ExprUtils.asBool((Expr)new Call(CodeLocation.NONE, (DynamicExpr)new Variable(CodeLocation.NONE, "version"), List.of(new Call.Argument(ExprUtils.asDynamic((Expr)Expr.literal((String)mod)), false), new Call.Argument(ExprUtils.asDynamic((Expr)Expr.literal((String)predicate)), false))));
        }
        Object e = null;
        String[] arr = name.split("[:.]");
        for (int i = 0; i < arr.length; ++i) {
            e = i == 0 ? new Variable(CodeLocation.NONE, arr[i]) : new Get(CodeLocation.NONE, (DynamicExpr)e, Expr.literal((String)arr[i]));
        }
        if (e == null) {
            throw new MalformedDataException("Invalid RPO condition: \"" + name + "\"");
        }
        return ExprUtils.asBool(e);
    }

    public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(BoolExpr boolExpr, Writer writer) throws TEx, MalformedDataException {
        ExprTypeAdapter.INSTANCE.serialize((Expr)boolExpr, writer);
    }
}

