/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.muscript;

import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.core.SourceFS;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.additional.libs.IOLib;
import io.gitlab.jfronny.muscript.data.additional.libs.IOWrapper;
import io.gitlab.jfronny.muscript.data.additional.libs.StandardLib;
import io.gitlab.jfronny.muscript.json.JsonLib;
import io.gitlab.jfronny.respackopts.model.cache.CachedPackState;
import io.gitlab.jfronny.respackopts.muscript.ScopeVersion;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.platform.VersionParseException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;

public class MuScriptScope {
    private static final Map<ScopeVersion, Scope> map = new EnumMap<ScopeVersion, Scope>(ScopeVersion.class);

    private static <Version> boolean checkVersion(Platform<Version> platform, String modId, String predicateArg) {
        Predicate<Version> predicate;
        try {
            predicate = platform.parseVersionPredicate(predicateArg);
        }
        catch (VersionParseException e) {
            throw new IllegalArgumentException("Could not parse version predicate", e);
        }
        return platform.getVersion(modId).map(predicate::test).orElse(false);
    }

    public static Scope fork(int version) {
        return map.get((Object)ScopeVersion.by(version)).fork();
    }

    public static Scope configureFS(Scope scope, CachedPackState state, SourceFS fs) {
        MuScriptVersion version = ScopeVersion.by((int)state.metadata().version).muScriptVersion;
        return IOLib.addTo((MuScriptVersion)version, (Scope)scope, (IOWrapper)new IOWrapper.Caching((IOWrapper)new IOWrapper.SourceFSWrapper(version, fs)));
    }

    static {
        for (ScopeVersion version : ScopeVersion.values()) {
            Scope scope = StandardLib.createScope((MuScriptVersion)version.muScriptVersion);
            scope = scope.set("version", args -> {
                if (args.size() != 2) {
                    throw new IllegalArgumentException("Expected 2 arguments on version but got " + args.size());
                }
                return DFinal.of((boolean)MuScriptScope.checkVersion(Platform.getInstance(), args.get(0).asString().getValue(), args.get(1).asString().getValue()));
            });
            if (version.contains(ScopeVersion.V13)) {
                scope = JsonLib.addTo((Scope)scope);
            }
            map.put(version, scope);
        }
    }
}

