/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.model.enums.ConfigSyncMode;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.entry.NumericEntryTypeAdapter;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import java.util.Objects;

@SerializeWithAdapter(adapter=NumericEntryTypeAdapter.class)
public class ConfigNumericEntry
extends ConfigEntry<Double>
implements DNumber {
    private Double min = null;
    private Double max = null;
    private boolean integer = false;

    public ConfigNumericEntry() {
        super(Double.class);
        this.setValue(0.0);
    }

    public ConfigNumericEntry asInteger() {
        this.integer = true;
        if (this.min != null && this.min % 1.0 != 0.0) {
            this.integer = false;
            throw new RuntimeException("Minimum value (" + this.min + ") is not integer for integer entry");
        }
        if (this.max != null && this.max % 1.0 != 0.0) {
            this.integer = false;
            throw new RuntimeException("Minimum value (" + this.max + ") is not integer for integer entry");
        }
        return this;
    }

    public void setMin(Double value) {
        if (value != null && this.integer && value % 1.0 != 0.0) {
            throw new RuntimeException("Minimum value (" + value + ") is not integer for integer entry");
        }
        this.min = value;
    }

    public void setMax(Double value) {
        if (value != null && this.integer && value % 1.0 != 0.0) {
            throw new RuntimeException("Maximum value (" + value + ") is not integer for integer entry");
        }
        this.max = value;
    }

    @Override
    public Double setDefault(Double value) {
        if (this.integer && value % 1.0 != 0.0) {
            throw new RuntimeException("Default value (" + value + ") is not integer for integer entry");
        }
        if (this.min != null && value < this.min || this.max != null && value > this.max) {
            throw new RuntimeException("Default value (" + value + ") out of range in number entry definition (" + this.min + "-" + this.max + ")");
        }
        return super.setDefault(value);
    }

    @Override
    public void sync(ConfigEntry<Double> source, ConfigSyncMode mode) {
        super.sync(source, mode);
        ConfigNumericEntry n = (ConfigNumericEntry)source;
        if (mode == ConfigSyncMode.RESPACK_LOAD) {
            this.min = n.min;
            this.max = n.max;
            this.integer = n.integer;
        }
    }

    @Override
    public void appendString(IndentingStringBuilder sb) {
        sb.line(String.valueOf(this.getValue()) + " (" + String.valueOf(this.getDefault()) + ", " + this.min + "-" + this.max + (this.integer ? ", integer" : "") + ")");
    }

    @Override
    public ConfigEntry<Double> clone() {
        ConfigNumericEntry ce = new ConfigNumericEntry();
        ce.setMax(this.max);
        ce.setMin(this.min);
        ce.setValue((Double)this.getValue());
        ce.setDefault((Double)this.getDefault());
        return this.integer ? ce.asInteger() : ce;
    }

    @Override
    public void buildShader(StringBuilder sb, String valueName) {
        sb.append("\n#define ");
        sb.append(valueName);
        sb.append(' ');
        sb.append(((Double)this.getValue()).toString());
    }

    @Override
    public CategoryBuilder<?> buildEntry(GuiEntryBuilderParam args) {
        double max;
        double min = this.min == null ? Double.NEGATIVE_INFINITY : this.min;
        double d = max = this.max == null ? Double.POSITIVE_INFINITY : this.max;
        if (this.integer) {
            return args.builder().value(args.name(), ConfigNumericEntry.asLong((Double)this.getDefault()).longValue(), min, max, () -> ConfigNumericEntry.asLong((Double)this.getValue()), v -> {
                boolean changed = !Objects.equals(ConfigNumericEntry.asLong((Double)this.getValue()), v);
                this.setValue(v == null ? null : Double.valueOf(v.doubleValue()));
                if (changed) {
                    if (RespackoptsConfig.debugLogs) {
                        Respackopts.LOGGER.info("ConfigNumericEntryNormal SaveCallback", new Object[0]);
                    }
                    args.saveCallback();
                }
            });
        }
        return args.builder().value(args.name(), ((Double)this.getDefault()).doubleValue(), min, max, this::getValue, v -> {
            boolean changed = !Objects.equals(this.getValue(), v);
            this.setValue(v);
            if (changed) {
                if (RespackoptsConfig.debugLogs) {
                    Respackopts.LOGGER.info("ConfigNumericEntryNormal SaveCallback", new Object[0]);
                }
                args.saveCallback();
            }
        });
    }

    private static Long asLong(Double d) {
        return d == null ? null : Long.valueOf(d.longValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigNumericEntry)) {
            return false;
        }
        ConfigNumericEntry that = (ConfigNumericEntry)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getDefault(), that.getDefault()) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.integer == that.integer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue(), this.getDefault(), this.min, this.max, this.integer);
    }
}

