/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import com.google.common.collect.ImmutableMap;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.DelegateDynamic;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.model.enums.ConfigSyncMode;
import io.gitlab.jfronny.respackopts.model.enums.PackReloadType;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.entry.ConfigBranchTypeAdapter;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_7367;

@SerializeWithAdapter(adapter=ConfigBranchTypeAdapter.class)
public class ConfigBranch
extends ConfigEntry<Map<String, ConfigEntry<?>>>
implements DelegateDynamic {
    private final Map<String, class_7367<ConfigBranch>> presets = new HashMap<String, class_7367<ConfigBranch>>();

    public ConfigBranch() {
        super(new TypeToken<Map<String, ConfigEntry<?>>>(){}.getRawType());
        this.setValue(new LinkedHashMap());
    }

    private void checkValue() {
        if (this.version < 10) {
            return;
        }
        Iterator iterator = this.getValue().keySet().iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (Respackopts.isLegal(s)) continue;
            Respackopts.LOGGER.error("Illegal entry for {0}, skipping: {1}", new Object[]{this.getName(), s});
            iterator.remove();
        }
    }

    @Override
    public Map<String, ConfigEntry<?>> setValue(Map<String, ConfigEntry<?>> value) {
        Map<String, ConfigEntry<?>> res = super.setValue(value);
        this.checkValue();
        return res;
    }

    @Override
    public void sync(ConfigEntry<Map<String, ConfigEntry<?>>> source, ConfigSyncMode mode) {
        for (Map.Entry<String, ConfigEntry<?>> e : source.getValue().entrySet()) {
            if (!this.has(e.getKey())) {
                if (mode != ConfigSyncMode.RESPACK_LOAD) continue;
                this.add(e.getKey(), (ConfigEntry)e.getValue().clone());
                continue;
            }
            ConfigEntry<?> current = this.get(e.getKey());
            if (e.getValue().getEntryClass().equals(current.getEntryClass())) {
                this.syncSub(current, e.getValue(), mode);
                continue;
            }
            if (mode == ConfigSyncMode.RESPACK_LOAD) {
                Respackopts.LOGGER.warn("Type mismatch in config ({0}), overwriting", new Object[]{this.getName()});
                this.add(e.getKey(), (ConfigEntry)e.getValue().clone());
                continue;
            }
            Respackopts.LOGGER.warn("Type mismatch in config ({0}}), ignoring", new Object[]{this.getName()});
        }
        if (mode == ConfigSyncMode.RESPACK_LOAD) {
            this.getValue().forEach((key, value) -> {
                if (!((Map)source.getValue()).containsKey(key)) {
                    ((Map)super.getValue()).remove(key);
                }
            });
            if (source instanceof ConfigBranch) {
                ConfigBranch cb = (ConfigBranch)source;
                this.setPresets(cb.presets);
            }
        }
    }

    private <T> void syncSub(ConfigEntry<T> current, ConfigEntry<T> next, ConfigSyncMode mode) {
        current.sync(next, mode);
    }

    public <T> void add(String name, ConfigEntry<T> val) {
        if (this.version >= 10 && !Respackopts.isLegal(name)) {
            Respackopts.LOGGER.error("Illegal entry for {0}, skipping: {1}", new Object[]{this.getName(), name});
            return;
        }
        val.setVersion(this.version);
        val.parent = this;
        ((Map)super.getValue()).put(name, val);
    }

    public ConfigEntry<?> get(String key) {
        return (ConfigEntry)((Map)super.getValue()).get(key);
    }

    public String getEntryName(ConfigEntry<?> entry) {
        for (Map.Entry e : this.getValue().entrySet()) {
            if (e.getValue() != entry) continue;
            return (String)e.getKey();
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean has(String key) {
        return ((Map)super.getValue()).containsKey(key);
    }

    @Override
    public Map<String, ConfigEntry<?>> getValue() {
        return ImmutableMap.copyOf((Map)((Map)super.getValue()));
    }

    @Override
    public void buildShader(StringBuilder sb, String valueName) {
        ((Map)super.getValue()).forEach((key, value) -> value.buildShader(sb, valueName + "_" + Respackopts.sanitizeString(key)));
    }

    public Dynamic getDelegate() {
        HashMap map = new HashMap();
        ((Map)super.getValue()).forEach((key, value) -> {
            if (Respackopts.isLegal(key)) {
                map.put(key, value);
            } else if (this.version >= 10) {
                Respackopts.LOGGER.error("Illegal key in {0}, skipping: {1}", new Object[]{this.getName(), key});
            } else {
                map.put(Respackopts.sanitizeString(key), value);
            }
        });
        return DFinal.of(map);
    }

    public Scope addTo(Scope scope) {
        ((Map)super.getValue()).forEach((key, value) -> scope.set(this.version >= 10 ? key : Respackopts.sanitizeString(key), (Dynamic)value));
        return scope;
    }

    public void setPresets(Map<String, class_7367<ConfigBranch>> presets) {
        this.presets.clear();
        this.presets.putAll(presets);
    }

    @Override
    public CategoryBuilder<?> buildEntry(GuiEntryBuilderParam builder) {
        return builder.builder().category(builder.name(), cb -> this.addTo(cb, value -> builder.onSave().run()));
    }

    public <T extends ConfigBuilder<?>> T buildConfig(T builder, Path dataLocation) {
        PackReloadType.Aggregator agg = new PackReloadType.Aggregator();
        this.addTo(builder, value -> agg.accept(value.getReloadType()));
        builder.setWriteMethod(cfg -> {
            if (RespackoptsConfig.debugLogs) {
                Respackopts.LOGGER.info("GuiFactory SavingRunnable {0}", new Object[]{agg.get()});
            }
            MetaCache.save(new SaveHook.Arguments(agg.get() == PackReloadType.Resource, false, true));
        });
        builder.setPath(dataLocation);
        return builder;
    }

    private <T extends CategoryBuilder<?>> T addTo(T builder, Consumer<ConfigEntry<?>> onSave) {
        Object entries = this.getValue();
        entries.forEach((key, value) -> value.buildEntry(new GuiEntryBuilderParam(builder, (String)key, () -> onSave.accept((ConfigEntry<?>)value))));
        this.presets.forEach((key, value) -> builder.addPreset(key, ConfigBranch.makePreset((class_7367<ConfigBranch>)value, key, this)));
        return builder;
    }

    private static Runnable makePreset(class_7367<ConfigBranch> preset, String presetName, ConfigBranch target) {
        return () -> {
            try {
                target.sync((ConfigEntry)preset.get(), ConfigSyncMode.CONF_LOAD);
            }
            catch (Throwable e) {
                Respackopts.LOGGER.error("Could not load preset: {0}", e, new Object[]{presetName});
            }
        };
    }

    @Override
    public void appendString(IndentingStringBuilder sb) {
        IndentingStringBuilder ind = sb.indent();
        this.getValue().forEach((key, value) -> {
            ind.line("- " + value.getName() + ":");
            value.appendString(ind);
        });
    }

    @Override
    public ConfigBranch clone() {
        ConfigBranch branch = new ConfigBranch();
        this.getValue().forEach((key, value) -> {
            Object entry = value.clone();
            ((ConfigEntry)entry).setReloadType(value.getReloadType());
            branch.add((String)key, (ConfigEntry)entry);
        });
        branch.setVersion(this.getVersion());
        branch.setPresets(this.presets);
        return branch;
    }

    @Override
    public void setVersion(int version) {
        super.setVersion(version);
        for (ConfigEntry value : this.getValue().values()) {
            value.setVersion(version);
        }
        this.checkValue();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ConfigBranch)) {
            return false;
        }
        ConfigBranch other = (ConfigBranch)o;
        Object otherMap = other.getValue();
        if (otherMap.size() != this.getValue().size()) {
            return false;
        }
        for (Map.Entry entry : this.getValue().entrySet()) {
            if (!otherMap.containsKey(entry.getKey())) {
                return false;
            }
            if (((ConfigEntry)otherMap.get(entry.getKey())).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        ArrayList<Integer> source = new ArrayList<Integer>();
        this.getValue().forEach((key, value) -> {
            source.add((Integer)key);
            source.add((Integer)value);
        });
        source.add(super.hashCode());
        return Objects.hash(source.toArray());
    }
}

