/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.tree;

import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.model.tree.ConfigEntry;
import io.gitlab.jfronny.respackopts.model.tree.GuiEntryBuilderParam;
import io.gitlab.jfronny.respackopts.serialization.entry.BooleanEntryTypeAdapter;
import java.util.Objects;

@SerializeWithAdapter(adapter=BooleanEntryTypeAdapter.class)
public class ConfigBooleanEntry
extends ConfigEntry<Boolean>
implements DBool {
    public ConfigBooleanEntry(boolean v) {
        super(Boolean.class);
        this.setValue(v);
        this.setDefault(v);
    }

    @Override
    public ConfigEntry<Boolean> clone() {
        ConfigBooleanEntry be = new ConfigBooleanEntry((Boolean)this.getValue());
        be.setDefault((Boolean)this.getDefault());
        return be;
    }

    @Override
    public void buildShader(StringBuilder sb, String valueName) {
        if (((Boolean)this.getValue()).booleanValue()) {
            sb.append("\n#define ");
            sb.append(valueName);
        }
    }

    @Override
    public CategoryBuilder<?> buildEntry(GuiEntryBuilderParam args) {
        return args.builder().value(args.name(), ((Boolean)this.getDefault()).booleanValue(), this::getValue, v -> {
            boolean changed = this.getValue() != v;
            this.setValue(v);
            if (changed) {
                if (RespackoptsConfig.debugLogs) {
                    Respackopts.LOGGER.info("ConfigBooleanEntry SaveCallback", new Object[0]);
                }
                args.saveCallback();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof ConfigBooleanEntry)) return false;
        ConfigBooleanEntry cb = (ConfigBooleanEntry)o;
        if (!((Boolean)this.getValue()).equals(cb.getValue())) return false;
        if (!((Boolean)this.getDefault()).equals(cb.getDefault())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue(), this.getDefault());
    }
}

