/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters.util;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.model.FileRpo;
import io.gitlab.jfronny.respackopts.model.GC_FileRpo;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.model.cache.CachedPackState;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.serialization.AttachmentHolder;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.class_7367;

public class FileRpoSearchProvider {
    public static boolean isRpo(String fileName) {
        return fileName.endsWith(".rpo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T modifyWithRpo(String fileName, CacheKey key, RespackoptsFS fs, Action<T> action, T defaultValue) {
        if (FileRpoSearchProvider.isRpo(fileName)) {
            return defaultValue;
        }
        CachedPackState state = MetaCache.getState(key);
        String rpoPathS = fileName + ".rpo";
        class_7367<InputStream> is = fs.open(rpoPathS);
        if (is == null) {
            return defaultValue;
        }
        if (state.tracker() != null) {
            state.tracker().addDependency(fileName, rpoPathS);
        }
        try (InputStreamReader w = new InputStreamReader((InputStream)is.get());){
            FileRpo frp = (FileRpo)AttachmentHolder.attach(state.metadata().version, () -> GC_FileRpo.deserialize(w, LibJf.LENIENT_TRANSPORT));
            frp.hydrate(rpoPathS);
            T t = action.run(frp);
            return t;
        }
        catch (Exception e) {
            Respackopts.LOGGER.error("Could not get replacement for " + fileName + " in " + state.displayName(), (Throwable)e);
            return defaultValue;
        }
    }

    public static interface Action<T> {
        public T run(FileRpo var1);
    }
}

