/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters.util;

import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.filters.util.FileRpoSearchProvider;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.InputStream;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class FileFallbackProvider {
    public static class_7367<InputStream> getReplacement(CacheKey key, RespackoptsFS fs, String file) {
        return FileRpoSearchProvider.modifyWithRpo(file, key, fs, rpo -> {
            if (rpo.fallbacks == null) {
                return null;
            }
            try {
                for (String s : rpo.fallbacks) {
                    MetaCache.addDependency(key, file, s);
                    class_7367<InputStream> is = fs.open(s);
                    if (is == null) continue;
                    return is;
                }
                Respackopts.LOGGER.error("Could not determine replacement for {0}", new Object[]{file});
            }
            catch (Exception e) {
                Respackopts.LOGGER.error("Could not determine replacement for {0}", (Throwable)e, new Object[]{file});
            }
            return null;
        }, null);
    }

    public static void addFallbackResources(String namespace, class_3264 type, class_2960 identifier, CacheKey key, RespackoptsFS fs, Set<class_2960> ids, class_3262.class_7664 out) {
        String path = identifier.method_12832();
        if (!FileRpoSearchProvider.isRpo(path)) {
            return;
        }
        String expectedTarget = path.substring(0, path.length() - ".rpo".length());
        if (ids.stream().anyMatch(s -> s.method_12832().equals(expectedTarget))) {
            return;
        }
        class_7367<InputStream> replacement = FileFallbackProvider.getReplacement(key, fs, type.method_14413() + "/" + expectedTarget);
        if (replacement == null) {
            return;
        }
        class_2960 id = class_2960.method_60655((String)namespace, (String)expectedTarget);
        ids.add(id);
        out.accept((Object)id, replacement);
    }
}

