/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.data.additional.DEnum;
import io.gitlab.jfronny.muscript.data.additional.DataExprMapper;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.parser.Parser;
import io.gitlab.jfronny.muscript.runtime.Runtime;
import io.gitlab.jfronny.muscript.serialize.Decompiler;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsClient;
import io.gitlab.jfronny.respackopts.integration.ShaderIntegration;
import io.gitlab.jfronny.respackopts.muscript.ScopeVersion;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.platform.PlatformClient;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;

public class RpoClientCommand {
    private static final Path dumpPath = Platform.getInstance().getGameDir().resolve("respackopts").toAbsolutePath();

    public static <S extends class_2172> LiteralArgumentBuilder<S> tree(PlatformClient<S> platform) {
        String modVersion = Platform.getInstance().getVersion("respackopts").orElseThrow().toString();
        Command getVersion = ctx -> {
            platform.sendFeedback((class_2172)ctx.getSource(), (class_2561)class_2561.method_43469((String)"respackopts.versionText", (Object[])new Object[]{modVersion, Respackopts.META_VERSION}));
            return 1;
        };
        Command dumpConfig = ctx -> {
            MetaCache.forEach((id, branch) -> platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump(branch.toString(), branch.packId() + ".txt")));
            return 1;
        };
        Command dumpGlsl = ctx -> {
            platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump(ShaderIntegration.getShaderImportSource(), "frex.glsl"));
            return 1;
        };
        Command dumpScope = ctx -> {
            platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump((Dynamic)MetaCache.getScope(Respackopts.META_VERSION), "_root.mu"));
            MetaCache.forEach((id, branch) -> platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump((Dynamic)branch.executionScope().getOverrides(), branch.packId() + ".mu")));
            return 1;
        };
        Command dumpScopeVersioned = ctx -> {
            platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump((Dynamic)MetaCache.getScope(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"version")), "_root.mu"));
            MetaCache.forEach((id, branch) -> platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump((Dynamic)branch.executionScope().getOverrides(), branch.packId() + ".mu")));
            return 1;
        };
        Command dumpAsset = ctx -> {
            class_2960 id = (class_2960)ctx.getArgument("asset", class_2960.class);
            platform.sendFeedback((class_2172)ctx.getSource(), RpoClientCommand.dump((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> class_310.method_1551().method_1478().open(id)), id.method_12836() + "/" + id.method_12832()));
            return 1;
        };
        Command execute = ctx -> {
            String snippet = StringArgumentType.getString((CommandContext)ctx, (String)"snippet");
            try {
                int ver = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"version");
                Dynamic selector0$temp = Runtime.evaluate((Expr)Parser.parse((MuScriptVersion)ScopeVersion.by((int)ver).muScriptVersion, (String)snippet, (String)"snippet"), (Scope)MetaCache.getScope(ver));
                int index$1 = 0;
                String result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DEnum.DEnumEntry.class, Dynamic.class}, (Object)selector0$temp, index$1)) {
                    case -1 -> "null";
                    case 0 -> {
                        DEnum.DEnumEntry de = (DEnum.DEnumEntry)selector0$temp;
                        yield de.asBool().getValue().toString();
                    }
                    default -> {
                        Dynamic other = selector0$temp;
                        yield other.asString().getValue();
                    }
                };
                platform.sendFeedback((class_2172)ctx.getSource(), (class_2561)class_2561.method_43469((String)"respackopts.snippet.success", (Object[])new Object[]{result}));
            }
            catch (LocationalException | Parser.ParseException e) {
                Respackopts.LOGGER.error("Could not execute snippet", e);
                platform.sendError((class_2172)ctx.getSource(), (class_2561)class_2561.method_43469((String)"respackopts.snippet.failed", (Object[])new Object[]{e.getMessage()}));
            }
            return 1;
        };
        Command reload = ctx -> {
            MetaCache.clear();
            ((CompletableFuture)CompletableFuture.allOf(RespackoptsClient.forceReloadResources(), RespackoptsClient.reloadIntegratedServerData()).thenRun(() -> platform.sendFeedback((class_2172)ctx.getSource(), (class_2561)class_2561.method_43471((String)"respackopts.reloadSucceeded")))).exceptionally(e -> {
                Respackopts.LOGGER.error("Could not reload resources", e);
                platform.sendError((class_2172)ctx.getSource(), (class_2561)class_2561.method_43471((String)"respackopts.reloadFailed"));
                return null;
            });
            return 1;
        };
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)platform.literal("rpoc").executes(getVersion)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)platform.literal("dump").executes(dumpConfig)).then(platform.literal("config").executes(dumpConfig))).then(((LiteralArgumentBuilder)platform.literal("scope").executes(dumpScope)).then(platform.argument("version", IntegerArgumentType.integer((int)1, (int)Respackopts.META_VERSION)).executes(dumpScopeVersioned)))).then(platform.literal("glsl").executes(dumpGlsl))).then(platform.literal("asset").then(platform.argument("asset", class_2232.method_9441()).executes(dumpAsset))))).then(platform.literal("execute").then(platform.argument("version", IntegerArgumentType.integer((int)1, (int)Respackopts.META_VERSION)).then(platform.argument("snippet", StringArgumentType.greedyString()).executes(execute))))).then(platform.literal("version").executes(getVersion))).then(platform.literal("reload").executes(reload));
    }

    private static class_2561 dump(Dynamic dynamic, String fileName) {
        return RpoClientCommand.dump(DataExprMapper.map((Dynamic)dynamic), fileName);
    }

    private static class_2561 dump(Expr expr, String fileName) {
        return RpoClientCommand.dump(Decompiler.decompile((Expr)expr), fileName);
    }

    private static class_2561 dump(String text, String fileName) {
        return RpoClientCommand.dump((ThrowingConsumer<Path, IOException>)((ThrowingConsumer)path -> Files.writeString(path, (CharSequence)text, StandardOpenOption.CREATE)), fileName);
    }

    private static class_2561 dump(ThrowingSupplier<InputStream, IOException> content, String fileName) {
        return RpoClientCommand.dump((ThrowingConsumer<Path, IOException>)((ThrowingConsumer)path -> {
            try (InputStream is = (InputStream)content.get();
                 OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
        }), fileName);
    }

    private static class_2561 dump(ThrowingConsumer<Path, IOException> content, String fileName) {
        try {
            Path filePath = dumpPath.resolve(fileName).normalize();
            if (!filePath.startsWith(dumpPath)) {
                throw new IOException("Illegal path");
            }
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            content.accept((Object)filePath);
            return class_2561.method_43469((String)"respackopts.dumpSucceeded", (Object[])new Object[]{filePath.toAbsolutePath()});
        }
        catch (Throwable e) {
            Respackopts.LOGGER.error("Could not dump resource", e);
            return class_2561.method_43471((String)"respackopts.dumpFailed");
        }
    }
}

