/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.respackopts.JFC_RespackoptsConfig;
import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.server.ServerInstanceHolder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

public class Respackopts
implements SaveHook {
    public static final Integer META_VERSION = 13;
    public static final String FILE_EXTENSION = ".rpo";
    public static final String ID = "respackopts";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"respackopts");
    public static final Path FALLBACK_CONF_DIR = Platform.getInstance().getConfigDir().resolve("respackopts");
    private static final Pattern UNSUPPORTED;
    private static final Pattern SANITIZABLE;

    @Override
    public CompletableFuture<Void> onSave(SaveHook.Arguments args) {
        JFC_RespackoptsConfig.INSTANCE.write();
        if (args.reloadData() && Platform.getInstance().isDedicatedServer()) {
            ServerInstanceHolder.reloadResources();
        }
        return CompletableFuture.completedFuture(null);
    }

    public static String sanitizeString(String s) {
        return SANITIZABLE.matcher(s).replaceAll("");
    }

    public static boolean isLegal(String s) {
        return !UNSUPPORTED.matcher(s).find();
    }

    static {
        try {
            Files.createDirectories(FALLBACK_CONF_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not initialize config directory", (Throwable)e);
        }
        UNSUPPORTED = Pattern.compile("\\W+|^\\d+");
        SANITIZABLE = Pattern.compile(String.valueOf(UNSUPPORTED) + "|^_+|_+$");
    }
}

