/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe.asm.patch.modification;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.unsafe.asm.AsmTransformer;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.MethodPatch;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.Patch;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.PatchUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodModificationPatch
implements Patch {
    private final Map<Key, MethodPatch> patches = new LinkedHashMap<Key, MethodPatch>();

    public MethodModificationPatch(String targetMethodOwner, Set<MethodDescriptorPatch> patches) {
        for (MethodDescriptorPatch patch : patches) {
            this.patches.put(new Key(PatchUtil.mapMethodName(targetMethodOwner, patch.methodName, patch.methodDescriptor), PatchUtil.mapDescriptor(patch.methodDescriptor)), patch.patch);
        }
        for (Key s : this.patches.keySet()) {
            if (!AsmTransformer.INSTANCE.debugLogsEnabled()) continue;
            LibJf.LOGGER.info("Registered patch for " + String.valueOf(s), new Object[0]);
        }
    }

    @Override
    public boolean apply(ClassNode klazz) {
        boolean modified = false;
        for (MethodNode method : klazz.methods) {
            MethodPatch mp = this.patches.get(new Key(method.name, method.desc));
            if (mp == null) continue;
            if (AsmTransformer.INSTANCE.debugLogsEnabled()) {
                LibJf.LOGGER.info("Patching " + method.name, new Object[0]);
            }
            modified |= mp.apply(method, klazz);
        }
        return modified;
    }

    public record MethodDescriptorPatch(String methodName, String methodDescriptor, MethodPatch patch) {
    }

    private record Key(String name, String descriptor) {
        @Override
        public String toString() {
            return this.name + this.descriptor;
        }
    }
}

