/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe.asm;

import io.gitlab.jfronny.libjf.Flags;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.unsafe.asm.AsmConfig;
import io.gitlab.jfronny.libjf.unsafe.asm.BakedAsmConfig;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.Patch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;
import org.spongepowered.asm.transformers.MixinClassWriter;

public class AsmTransformer
implements IMixinTransformer {
    public static AsmTransformer INSTANCE;
    public static final MappingResolver MAPPING_RESOLVER;
    public static final String INTERMEDIARY = "intermediary";
    public IMixinTransformer delegate;
    public Set<BakedAsmConfig> asmConfigs;
    private AsmConfig currentConfig = null;
    private boolean export;
    private boolean debugLog;

    public void init() {
        LinkedHashSet<String> flagNames;
        Set flags = Flags.getBoolFlags((String)"asm.export");
        flags.removeIf(flag -> !flag.value());
        boolean bl = this.export = !flags.isEmpty();
        if (this.export) {
            flagNames = new LinkedHashSet<String>();
            for (Flags.BooleanFlag flag2 : flags) {
                flagNames.add(flag2.source());
            }
            LibJf.LOGGER.info("Exporting ASM due to: " + String.join((CharSequence)", ", flagNames), new Object[0]);
        }
        flags = Flags.getBoolFlags((String)"asm.log");
        flags.removeIf(flag -> !flag.value());
        boolean bl2 = this.debugLog = !flags.isEmpty();
        if (this.debugLog) {
            flagNames = new LinkedHashSet();
            for (Flags.BooleanFlag flag2 : flags) {
                flagNames.add(flag2.source());
            }
            LibJf.LOGGER.info("Logging ASM logs due to: " + String.join((CharSequence)", ", flagNames), new Object[0]);
        }
    }

    public boolean debugLogsEnabled() {
        return this.debugLog;
    }

    public void audit(MixinEnvironment environment) {
        this.delegate.audit(environment);
    }

    public List<String> reload(String mixinClass, ClassNode classNode) {
        return this.delegate.reload(mixinClass, classNode);
    }

    public boolean computeFramesForClass(MixinEnvironment environment, String name, ClassNode classNode) {
        return this.delegate.computeFramesForClass(environment, name, classNode);
    }

    public byte[] transformClassBytes(String name, String transformedName, byte[] classBytes) {
        return this.transform(this.delegate.transformClassBytes(name, transformedName, classBytes), name);
    }

    private byte[] transform(byte[] classBytes, String name) {
        if (classBytes == null || name == null) {
            return classBytes;
        }
        if (AsmTransformer.isClassUnmoddable(name, null)) {
            if (this.debugLogsEnabled()) {
                LibJf.LOGGER.info("Skipping " + name, new Object[0]);
            }
            return classBytes;
        }
        ClassNode klazz = new ClassNode();
        ClassReader reader = new ClassReader(classBytes);
        reader.accept((ClassVisitor)klazz, 8);
        if (!this.transform(klazz, name)) {
            return classBytes;
        }
        MixinClassWriter writer = new MixinClassWriter(reader, 2);
        try {
            klazz.accept((ClassVisitor)writer);
        }
        catch (NullPointerException t) {
            LibJf.LOGGER.error("Could not transform " + name, (Throwable)t);
            return null;
        }
        classBytes = writer.toByteArray();
        if (this.export) {
            try {
                Path path = FabricLoader.getInstance().getGameDir().resolve("libjf").resolve("asm").resolve(name.replace('.', '/') + ".class");
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, classBytes, new OpenOption[0]);
            }
            catch (IOException e) {
                LibJf.LOGGER.error("Could not export modified bytecode", (Throwable)e);
            }
        }
        return classBytes;
    }

    private boolean transform(ClassNode klazz, String name) {
        if (klazz == null || name == null) {
            return false;
        }
        if (AsmTransformer.isClassUnmoddable(name, null)) {
            if (this.debugLogsEnabled()) {
                LibJf.LOGGER.info("Skipping " + name, new Object[0]);
            }
            return false;
        }
        boolean modified = false;
        Iterator<BakedAsmConfig> iterator = this.asmConfigs.iterator();
        while (iterator.hasNext()) {
            AsmConfig config;
            this.currentConfig = config = (AsmConfig)iterator.next();
            if (AsmTransformer.isClassUnmoddable(name, config)) continue;
            for (Patch patch : config.getPatches()) {
                try {
                    modified |= patch.apply(klazz);
                }
                catch (Throwable t) {
                    LibJf.LOGGER.error("Could not apply patch: " + String.valueOf(patch.getClass()) + " on " + name, t);
                }
            }
        }
        this.currentConfig = null;
        return modified;
    }

    public byte[] transformClass(MixinEnvironment environment, String name, byte[] classBytes) {
        return this.transform(this.delegate.transformClass(environment, name, classBytes), name);
    }

    public boolean transformClass(MixinEnvironment environment, String name, ClassNode classNode) {
        boolean result = this.delegate.transformClass(environment, name, classNode);
        return result |= this.transform(classNode, name);
    }

    public byte[] generateClass(MixinEnvironment environment, String name) {
        return this.transform(this.delegate.generateClass(environment, name), name);
    }

    public boolean generateClass(MixinEnvironment environment, String name, ClassNode classNode) {
        boolean result = this.delegate.generateClass(environment, name, classNode);
        return result |= this.transform(classNode, name);
    }

    public IExtensionRegistry getExtensions() {
        return this.delegate.getExtensions();
    }

    public static boolean isClassUnmoddable(String className, AsmConfig config) {
        if ((className = className.replace('/', '.')).startsWith("org.objectweb.asm") || className.startsWith("org.spongepowered.asm")) {
            return true;
        }
        if (config == null) {
            return false;
        }
        Set<String> classes = config.skipClasses();
        if (classes == null) {
            return false;
        }
        return classes.contains(MAPPING_RESOLVER.unmapClassName(INTERMEDIARY, className));
    }

    public AsmConfig getCurrentConfig() {
        return this.currentConfig;
    }

    static {
        MAPPING_RESOLVER = FabricLoader.getInstance().getMappingResolver();
    }
}

