/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe;

import io.gitlab.jfronny.commons.unsafe.Unsafe;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.unsafe.DynamicEntry;
import io.gitlab.jfronny.libjf.unsafe.asm.AsmConfig;
import io.gitlab.jfronny.libjf.unsafe.asm.AsmTransformer;
import io.gitlab.jfronny.libjf.unsafe.asm.BakedAsmConfig;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> classLoaderClass = classLoader.getClass();
            Field delegateField = classLoaderClass.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Object delegate = delegateField.get(classLoader);
            Class<?> delegateClass = delegate.getClass();
            Field mixinTransformerField = delegateClass.getDeclaredField("mixinTransformer");
            mixinTransformerField.setAccessible(true);
            AsmTransformer.INSTANCE = Unsafe.allocateInstance(AsmTransformer.class);
            AsmTransformer.INSTANCE.delegate = (IMixinTransformer)mixinTransformerField.get(delegate);
            AsmTransformer.INSTANCE.asmConfigs = new HashSet<BakedAsmConfig>();
            DynamicEntry.execute("libjf:asm", AsmConfig.class, s -> {
                LibJf.LOGGER.info("Discovered LibJF asm plugin in " + s.modId(), new Object[0]);
                AsmTransformer.INSTANCE.asmConfigs.add(new BakedAsmConfig((AsmConfig)s.instance(), s.modId()));
            });
            AsmTransformer.INSTANCE.init();
            mixinTransformerField.set(delegate, AsmTransformer.INSTANCE);
        }
        catch (Throwable e) {
            LibJf.LOGGER.error("Could not initialize LibJF ASM", e);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

