/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl.deeplx.model;

import io.gitlab.jfronny.commons.serialize.annotations.SerializedName;
import java.util.List;
import java.util.Random;

public record PostData(String jsonrpc, String method, long id, Params params) {
    public PostData(String text, String from, String to, int alternatives) {
        this("2.0", "LMT_handle_texts", PostData.getId(), new Params(new Params.Text(text, alternatives), new Params.Lang(from, to)));
    }

    private static long getId() {
        long l = new Random(System.nanoTime()).nextLong(99999L) + 8300000L;
        return l * 1000L;
    }

    public record Params(List<Text> texts, String splitting, Lang lang, long timestamp, CommonJobParams commonJobParams) {
        public Params(Text text, Lang lang) {
            this(List.of(text), "newlines", lang, Params.getTime(text.text), new CommonJobParams());
        }

        private static long getTime(String text) {
            int count = text.chars().filter(ch -> ch == 105).sum();
            long time = System.nanoTime();
            if (count == 0) {
                return time;
            }
            return time - time % (long)(++count) + (long)count;
        }

        public record Lang(@SerializedName(value="source_lang_user_selected") String sourceLangUserSelected, @SerializedName(value="target_lang") String targetLang) {
        }

        public record CommonJobParams(boolean wasSpoken, @SerializedName(value="transcribe_as") String transcribeAs) {
            public CommonJobParams() {
                this(false, "");
            }
        }

        public record Text(String text, int requestAlternatives) {
            public Text {
                if (requestAlternatives < 0 || requestAlternatives > 3) {
                    throw new IllegalArgumentException("requestAlternatives must be between 0 and 3");
                }
            }
        }
    }
}

