/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl.deeplx;

import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.commons.serialize.json.JsonTransport;
import io.gitlab.jfronny.commons.serialize.json.JsonWriter;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.impl.AbstractTranslateService;
import io.gitlab.jfronny.libjf.translate.impl.Throttle;
import io.gitlab.jfronny.libjf.translate.impl.deeplx.DeepLXLanguage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class DeepLXService
extends AbstractTranslateService<DeepLXLanguage> {
    public static final String NAME = "DeepLX";
    private static DeepLXService INSTANCE;
    private static final Pattern LANGUAGE_KEY;
    private final Map<String, DeepLXLanguage> knownLanguages;
    private final Throttle throttle = new Throttle();
    private static final JsonTransport TRANSPORT;

    public static DeepLXService get() throws URISyntaxException, IOException {
        if (INSTANCE == null) {
            INSTANCE = new DeepLXService();
        }
        return INSTANCE;
    }

    private DeepLXService() throws URISyntaxException, IOException {
        HashMap<String, DeepLXLanguage> knownLanguages = new HashMap<String, DeepLXLanguage>();
        this.throttle.waitForNextRequest();
        Matcher matcher = LANGUAGE_KEY.matcher(HttpClient.get((String)"https://www.deepl.com/en/translator").sendString());
        while (matcher.find()) {
            String id = matcher.group(1).toUpperCase(Locale.ROOT);
            String name = matcher.group(2);
            knownLanguages.put(id, new DeepLXLanguage(name, id));
        }
        if (knownLanguages.isEmpty()) {
            throw new IOException("Could not detect languages, Google likely changed the site. Please inform the maintainer of LibJF");
        }
        this.knownLanguages = Map.copyOf(knownLanguages);
    }

    @Override
    protected DeepLXLanguage getAutoDetectLang() {
        return DeepLXLanguage.AUTO_DETECT;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected String performTranslate(String textToTranslate, DeepLXLanguage translateFrom, DeepLXLanguage translateTo) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream decode(InputStream in, List<String> encoding) throws IOException {
        return switch (encoding.isEmpty() ? "identity" : encoding.getFirst().toLowerCase(Locale.ROOT)) {
            case "gzip" -> new GZIPInputStream(in);
            case "deflate" -> new InflaterInputStream(in);
            default -> in;
        };
    }

    @Override
    public DeepLXLanguage detect(String text) throws TranslateException {
        return DeepLXLanguage.AUTO_DETECT;
    }

    @Override
    public DeepLXLanguage parseLang(String lang) {
        return this.knownLanguages.getOrDefault(lang.toUpperCase(Locale.ROOT), DeepLXLanguage.AUTO_DETECT);
    }

    @Override
    public List<DeepLXLanguage> getAvailableLanguages() {
        ArrayList<DeepLXLanguage> langs = new ArrayList<DeepLXLanguage>(this.knownLanguages.values());
        langs.remove(DeepLXLanguage.AUTO_DETECT);
        return langs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        LANGUAGE_KEY = Pattern.compile("selectLang_target_([a-z]+)'] = '([^']+)'");
        TRANSPORT = new JsonTransport(){

            public JsonWriter createWriter(Writer target) throws IOException {
                return super.createWriter(target).configureFormatting("", "", ": ", ", ");
            }

            public JsonReader createReader(Reader source) {
                return (JsonReader)super.createReader(source).setLenient(true);
            }
        };
    }
}

