/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.Reflowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntryListWidget
extends class_4265<ConfigEntry> {
    private final class_327 textRenderer;

    public EntryListWidget(class_310 client, class_327 tr, int width, int height, int top) {
        super(client, width, height, top, 25);
        this.field_22744 = false;
        this.textRenderer = tr;
    }

    public int method_65507() {
        return this.field_22758 - 7;
    }

    public void addUnknown(class_339 resetButton, BooleanSupplier resetVisible, class_2561 text, Reflowable reflow) {
        this.method_25321((class_350.class_351)new ConfigUnknownEntry(text, resetVisible, resetButton, reflow, this.textRenderer));
    }

    public void addButton(@Nullable class_339 button, class_339 resetButton, BooleanSupplier resetVisible, class_2561 text, Reflowable reflow) {
        this.method_25321((class_350.class_351)new ConfigScreenEntry(button, text, resetVisible, resetButton, reflow, this.textRenderer));
    }

    public void addReference(class_2561 text, Supplier<class_437> targetScreen) {
        this.method_25321((class_350.class_351)new ConfigReferenceEntry(this.field_22758, text, targetScreen));
    }

    public void addText(class_2561 text) {
        for (ConfigEntry configEntry : ConfigTextEntry.create(this.textRenderer, this, (class_5348)text, this.field_22758)) {
            this.method_25321((class_350.class_351)configEntry);
        }
    }

    public int method_25322() {
        return 10000;
    }

    public Optional<class_2561> getHoveredEntryTitle(double mouseY) {
        for (ConfigEntry abstractEntry : this.method_25396()) {
            if (abstractEntry instanceof ConfigScreenEntry) {
                ConfigScreenEntry entry = (ConfigScreenEntry)abstractEntry;
                if (entry.button.field_22764 && mouseY >= (double)entry.button.method_46427() && mouseY < (double)(entry.button.method_46427() + this.field_22741)) {
                    return Optional.of(entry.getText());
                }
            }
            if (!(abstractEntry instanceof ConfigUnknownEntry)) continue;
            ConfigUnknownEntry entry = (ConfigUnknownEntry)abstractEntry;
            if (!(mouseY >= (double)entry.resetButton.method_46427()) || !(mouseY < (double)(entry.resetButton.method_46427() + this.field_22741))) continue;
            return Optional.of(entry.getText());
        }
        return Optional.empty();
    }

    public void refreshGrid(class_8030 tabArea) {
        int len;
        this.method_25358(tabArea.comp_1196());
        this.method_53533(tabArea.comp_1197());
        this.method_46421(tabArea.method_49620());
        this.method_46419(tabArea.method_49618());
        for (int i = len = this.method_25340() - 1; i >= 0; --i) {
            ((ConfigEntry)this.method_25326(i)).reflow(this.field_22758, this.field_22759);
        }
    }

    protected void method_25320(class_332 context, int mouseX, int mouseY) {
        super.method_25320(context, mouseX, mouseY);
        context.method_25296(this.method_46426(), this.method_46427(), this.method_55442(), this.method_46427() + 4, -16777216, 0);
        if (this.method_44387() < (double)this.method_44390()) {
            context.method_25296(this.method_46426(), this.method_55443() - 4, this.method_55442(), this.method_55443(), 0, -16777216);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigUnknownEntry
    extends ConfigEntry {
        private final BooleanSupplier resetVisible;
        private final class_339 resetButton;
        private final class_2561 text;
        private final Reflowable reflow;
        private final class_327 renderer;

        public ConfigUnknownEntry(class_2561 text, BooleanSupplier resetVisible, class_339 resetButton, Reflowable reflow, class_327 renderer) {
            this.resetVisible = resetVisible;
            this.resetButton = resetButton;
            this.text = text;
            this.reflow = reflow;
            this.renderer = renderer;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            context.method_27535(this.renderer, this.text, 12, y + 5, -1);
            if (this.resetVisible.getAsBoolean()) {
                this.resetButton.method_46419(y);
                this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        @Override
        public void reflow(int width, int height) {
            this.reflow.reflow(width, height);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigScreenEntry
    extends ConfigEntry {
        public final class_339 button;
        private final BooleanSupplier resetVisible;
        private final class_339 resetButton;
        private final class_2561 text;
        private final Reflowable reflow;
        private final class_327 renderer;

        public ConfigScreenEntry(class_339 button, class_2561 text, BooleanSupplier resetVisible, class_339 resetButton, Reflowable reflow, class_327 renderer) {
            this.button = button;
            this.resetVisible = resetVisible;
            this.resetButton = resetButton;
            this.text = text;
            this.reflow = reflow;
            this.renderer = renderer;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.button.method_46419(y);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
            context.method_27535(this.renderer, this.text, 12, y + 5, -1);
            if (this.resetVisible.getAsBoolean()) {
                this.resetButton.method_46419(y);
                this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        @Override
        public void reflow(int width, int height) {
            this.reflow.reflow(width, height);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button, this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigReferenceEntry
    extends ConfigEntry {
        private final class_339 button;

        public ConfigReferenceEntry(int width, class_2561 text, Supplier<class_437> targetScreen) {
            this.button = class_4185.method_46430((class_2561)text, btn -> class_310.method_1551().method_1507((class_437)targetScreen.get())).method_46434(width / 2 - 154, 0, 308, 20).method_46431();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.button.method_46419(y);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        public void reflow(int width, int height) {
            this.button.method_46421(width / 2 - 154);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ConfigTextEntry
    extends ConfigEntry {
        private int width;
        private final class_5481 text;
        private final class_327 renderer;
        public class_5348 originalText = null;

        public ConfigTextEntry(int width, class_5481 text, class_327 renderer) {
            this.width = width;
            this.text = text;
            this.renderer = renderer;
        }

        public static List<ConfigTextEntry> create(class_327 renderer, EntryListWidget parent, class_5348 text, int width) {
            ArrayList<ConfigTextEntry> entries = new ArrayList<ConfigTextEntry>();
            ArrayList wrappedLines = new ArrayList(renderer.method_1728(text, width));
            Collections.reverse(wrappedLines);
            for (class_5481 line : wrappedLines) {
                EntryListWidget entryListWidget = parent;
                Objects.requireNonNull(entryListWidget);
                entries.add(entryListWidget.new ConfigTextEntry(width, line, renderer));
            }
            if (!entries.isEmpty()) {
                ((ConfigTextEntry)entries.getLast()).originalText = text;
            }
            Collections.reverse(entries);
            return entries;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            int textX = (this.width - this.renderer.method_30880(this.text)) / 2;
            Objects.requireNonNull(this.renderer);
            int textY = y + (20 - 9) / 2;
            context.method_35720(this.renderer, this.text, textX, textY, -1);
        }

        @Override
        public void reflow(int width, int height) {
            this.width = width;
            if (this.originalText != null) {
                List children = EntryListWidget.this.method_25396();
                int i = children.indexOf(this);
                EntryListWidget.this.method_25330((class_350.class_351)this);
                for (ConfigTextEntry entry : ConfigTextEntry.create(this.renderer, EntryListWidget.this, this.originalText, width)) {
                    children.add(i++, entry);
                }
            } else {
                EntryListWidget.this.method_25330((class_350.class_351)this);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class ConfigEntry
    extends class_4265.class_4266<ConfigEntry>
    implements Reflowable {
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                context.method_25294(x, y, x + entryWidth, y + entryHeight, 0x24FFFFFF);
            }
        }
    }
}

