/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.api.v2.ui.ConfigScreenFactory;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.EditorScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.ScreenWithSaveHook;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigScreen;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TinyConfigScreenFactory
implements ConfigScreenFactory<class_437, Built> {
    public Built create(ConfigInstance config, Naming naming, class_437 parent) {
        if (config.getEntries().size() == 1 && config.getPresets().keySet().stream().allMatch(s -> s.equals("libjf-config-core-v2.default")) && config.getReferencedConfigs().isEmpty() && config.getCategories().isEmpty()) {
            Type type;
            EntryInfo entry = (EntryInfo)config.getEntries().getFirst();
            Type type2 = type = entry.supportsRepresentation() ? entry.getValueType() : null;
            if (!(type == null || type.isInt() || type.isLong() || type.isFloat() || type.isDouble() || type.isString() || type.isBool() || type.isEnum())) {
                return this.createJson(config, parent, entry, naming.entry(entry.getName()));
            }
        }
        return new Built(new TinyConfigScreen((ConfigCategory)config, naming, parent));
    }

    private <T> Built createJson(ConfigInstance config, class_437 parent, EntryInfo<T> entry, Naming.Entry naming) {
        String jsonified;
        try {
            Object value = entry.getValue();
            jsonified = LibJf.LENIENT_TRANSPORT.write(writer -> entry.serializeOneTo(value, (SerializeWriter)writer));
        }
        catch (IOException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return new Built(new EditorScreen(naming.name(), naming.tooltip(), parent, jsonified, json -> {
            try {
                entry.setValue(LibJf.LENIENT_TRANSPORT.read(json, arg_0 -> ((EntryInfo)entry).deserializeOneFrom(arg_0)));
                config.write();
            }
            catch (Throwable e) {
                LibJf.LOGGER.error("Could not write element", e);
                class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.write.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.write.fail.description"));
            }
        }));
    }

    public int getPriority() {
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public record Built(ScreenWithSaveHook screen) implements ConfigScreenFactory.Built<class_437>
    {
        public class_437 get() {
            return this.screen;
        }

        public void onSave(Runnable action) {
            Runnable currentHook = this.screen.saveHook;
            this.screen.saveHook = () -> {
                currentHook.run();
                action.run();
            };
        }
    }
}

