/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.Placeholder;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.ScreenWithSaveHook;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTab;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTabWrapper;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryListWidget;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.presets.PresetsScreen;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;

@Environment(value=EnvType.CLIENT)
public class TinyConfigScreen
extends ScreenWithSaveHook {
    private final class_437 parent;
    private final ConfigCategory config;
    private final Naming naming;
    public final List<WidgetState<?>> widgets;
    private final Placeholder<EntryListWidget> placeholder;
    private final class_8088 tabManager = new class_8088(a -> this.selectTab(((TinyConfigTabWrapper)((Object)a)).getTab()), R::nop);
    private List<TinyConfigTab> tabs;
    private final boolean considerTabs;
    public class_4185 done;
    private boolean reload = false;
    private boolean wasTabs = false;

    public TinyConfigScreen(ConfigCategory config, Naming naming, class_437 parent) {
        this(config, naming, parent, TinyConfigScreen.shouldConsiderTabs(config, naming));
    }

    public TinyConfigScreen(ConfigCategory config, Naming naming, class_437 parent, boolean considerTabs) {
        super(naming.name());
        this.parent = parent;
        this.config = config;
        this.naming = naming;
        this.widgets = new LinkedList();
        this.placeholder = new Placeholder<Object>(null);
        this.considerTabs = considerTabs;
    }

    private static boolean shouldConsiderTabs(ConfigCategory config, Naming naming) {
        return config.getEntries().isEmpty() && config.getReferencedConfigs().isEmpty() && config.getCategories().size() > 1 && naming.description() == null;
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.reload) {
            this.done = class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                for (WidgetState<?> state : this.widgets) {
                    Try.orElse(state::writeToEntry, e -> LibJf.LOGGER.error("Could not write config data to class", e));
                }
                this.config.getRoot().write();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
                this.saveHook.run();
            }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431();
        } else {
            this.done.method_48229(this.field_22789 / 2 + 4, this.field_22790 - 28);
        }
        this.updateTabs();
        class_8089 tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631((class_8087[])this.tabs.toArray(TinyConfigTab[]::new)).method_48627();
        if (this.tabs.size() > 1) {
            this.method_37063((class_364)tabNavigation);
        }
        tabNavigation.method_48987(0, false);
        tabNavigation.method_49613();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.method_37063((class_364)this.done);
        if (!this.config.getPresets().isEmpty()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-core-v2.presets"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new PresetsScreen(this, this.config, this.naming, this::afterSelectPreset))).method_46434(8, this.tabs.size() == 1 ? 6 : this.field_22790 - 28, 80, 20).method_46431());
        }
        this.method_37063(this.placeholder);
        this.tabManager.method_48616(new class_8030(0, 32, this.field_22789, this.field_22790 - 68));
        this.reload = true;
    }

    private void updateTabs() {
        boolean useTabs;
        boolean bl = useTabs = this.considerTabs && !this.tabsWouldOverflow(this.config.getCategories().values());
        if (this.reload) {
            if (!this.considerTabs) {
                return;
            }
            if (this.wasTabs == useTabs) {
                return;
            }
        }
        this.wasTabs = useTabs;
        this.tabs = useTabs ? this.config.getCategories().values().stream().map(c -> new TinyConfigTab(this, (ConfigCategory)c, this.naming.category(c.getId()), this.field_22793, false)).toList() : List.of(new TinyConfigTab(this, this.config, this.naming, this.field_22793, true));
    }

    private boolean tabsWouldOverflow(Collection<ConfigCategory> categories) {
        int tabNavWidth = this.field_22789;
        int headerWidth = Math.min(400, tabNavWidth) - 28;
        int singleHeaderWidth = class_3532.method_28139((int)(headerWidth / categories.size()), (int)2);
        int singleTextWidth = singleHeaderWidth - 2;
        for (ConfigCategory category : categories) {
            if (this.field_22793.method_27525((class_5348)this.naming.category(category.getId()).name()) <= singleTextWidth) continue;
            return true;
        }
        return false;
    }

    public void afterSelectPreset() {
        for (WidgetState<?> widget : this.widgets) {
            widget.updateCache();
        }
    }

    private void selectTab(TinyConfigTab tab) {
        this.placeholder.setChild(tab.getList());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Optional<class_2561> hovered;
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.tabs.size() == 1) {
            int n = this.field_22789 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, this.field_22785, n, 16 - 9, -1);
        }
        if ((hovered = this.placeholder.getChild().getHoveredEntryTitle(mouseY)).isPresent()) {
            for (WidgetState<?> info : this.widgets) {
                class_2561 name;
                class_2561 text = hovered.get();
                boolean showTooltip = text.equals((Object)(name = info.naming.name()));
                if (showTooltip && info.error != null) {
                    showTooltip = false;
                    context.method_51438(this.field_22793, info.error, mouseX, mouseY);
                }
                class_2561 tooltip = info.naming.tooltip();
                if (!showTooltip || tooltip == null) continue;
                showTooltip = false;
                context.method_51438(this.field_22793, tooltip, mouseX, mouseY);
            }
        }
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public class_310 getClient() {
        return Objects.requireNonNull(this.field_22787);
    }
}

