/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.impl.content.registry.util.ImmutableCollectionUtils;
import net.fabricmc.fabric.mixin.content.registry.AxeItemAccessor;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrippableBlockRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrippableBlockRegistryImpl.class);
    private static final IdentityHashMap<class_2248, StrippableBlockRegistry.StrippingTransformer> TRANSFORMERS = new IdentityHashMap();

    public static void register(class_2248 input, class_2248 stripped, StrippableBlockRegistry.StrippingTransformer transformer) {
        Objects.requireNonNull(input, "input block cannot be null");
        Objects.requireNonNull(stripped, "stripped block cannot be null");
        class_2248 old = StrippableBlockRegistryImpl.getRegistry().put(input, stripped);
        TRANSFORMERS.put(input, transformer);
        if (old != null) {
            LOGGER.debug("Replaced old stripping mapping from {} to {} with {}", new Object[]{input, old, stripped});
        }
    }

    private static Map<class_2248, class_2248> getRegistry() {
        return ImmutableCollectionUtils.getAsMutableMap(AxeItemAccessor::getStrippedBlocks, AxeItemAccessor::setStrippedBlocks);
    }

    @Nullable
    public static class_2680 getStrippedBlockState(class_2680 state) {
        class_2248 strippedBlock = StrippableBlockRegistryImpl.getRegistry().get(state.method_26204());
        if (strippedBlock == null) {
            return null;
        }
        return TRANSFORMERS.getOrDefault(state.method_26204(), StrippableBlockRegistry.StrippingTransformer.VANILLA).getStrippedBlockState(strippedBlock, state);
    }

    @Nullable
    public static StrippableBlockRegistry.StrippingTransformer getTransformer(class_2248 block) {
        return TRANSFORMERS.get(block);
    }
}

