/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag.convention.v2;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationConventionLogWarnings
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationConventionLogWarnings.class);
    private static final LogWarningMode LOG_UNTRANSLATED_WARNING_MODE = TranslationConventionLogWarnings.setupLogWarningModeProperty();

    private static LogWarningMode setupLogWarningModeProperty() {
        LogWarningMode defaultMode = FabricLoader.getInstance().isDevelopmentEnvironment() ? LogWarningMode.SHORT : LogWarningMode.SILENCED;
        String property = System.getProperty("fabric-tag-conventions-v2.missingTagTranslationWarning", defaultMode.name()).toUpperCase(Locale.ROOT);
        try {
            return LogWarningMode.valueOf(property);
        }
        catch (Exception e) {
            LOGGER.error("Unknown entry `{}` for property `fabric-tag-conventions-v2.missingTagTranslationWarning`.", (Object)property);
            return LogWarningMode.SILENCED;
        }
    }

    public void onInitialize() {
        if (LOG_UNTRANSLATED_WARNING_MODE != LogWarningMode.SILENCED) {
            TranslationConventionLogWarnings.setupUntranslatedItemTagWarning();
        }
    }

    private static void setupUntranslatedItemTagWarning() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_2477 language = class_2477.method_10517();
            class_2378 itemRegistry = server.method_30611().method_30530(class_7924.field_41197);
            ObjectArrayList untranslatedItemTags = new ObjectArrayList();
            itemRegistry.method_40272().forEach(arg_0 -> TranslationConventionLogWarnings.lambda$setupUntranslatedItemTagWarning$0(language, (List)untranslatedItemTags, arg_0));
            if (untranslatedItemTags.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n\tDev warning - Untranslated Item Tags detected. Please translate your item tags so other mods such as recipe viewers can properly display your tag's name.\n\tThe format desired is tag.item.<namespace>.<path> for the translation key with slashes in path turned into periods.\n\tTo disable this message, set this system property in your runs: `-Dfabric-tag-conventions-v2.missingTagTranslationWarning=SILENCED`.\n\tTo see individual untranslated item tags found, set the system property to `-Dfabric-tag-conventions-v2.missingTagTranslationWarning=VERBOSE`.\n\tDefault is `SHORT`.\n");
            if (LOG_UNTRANSLATED_WARNING_MODE.verbose()) {
                stringBuilder.append("\nUntranslated item tags:");
                for (class_6862 tagKey : untranslatedItemTags) {
                    stringBuilder.append("\n     ").append(tagKey.comp_327());
                }
            }
            LOGGER.warn(stringBuilder.toString());
            if (LOG_UNTRANSLATED_WARNING_MODE == LogWarningMode.FAIL) {
                throw new RuntimeException("Tag translation validation failed");
            }
        });
    }

    private static /* synthetic */ void lambda$setupUntranslatedItemTagWarning$0(class_2477 language, List untranslatedItemTags, class_6885.class_6888 itemTagKey) {
        if (itemTagKey.method_40251().comp_327().method_12836().equals("minecraft")) {
            return;
        }
        if (!language.method_4678(itemTagKey.method_40251().getTranslationKey())) {
            untranslatedItemTags.add(itemTagKey.method_40251());
        }
    }

    private static enum LogWarningMode {
        SILENCED,
        SHORT,
        VERBOSE,
        FAIL;


        boolean verbose() {
            return this == VERBOSE || this == FAIL;
        }
    }
}

