/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.runtime;

import io.gitlab.jfronny.muscript.ast.BoolExpr;
import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.NullLiteral;
import io.gitlab.jfronny.muscript.ast.NumberExpr;
import io.gitlab.jfronny.muscript.ast.StringExpr;
import io.gitlab.jfronny.muscript.ast.bool.And;
import io.gitlab.jfronny.muscript.ast.bool.BoolAssign;
import io.gitlab.jfronny.muscript.ast.bool.BoolConditional;
import io.gitlab.jfronny.muscript.ast.bool.BoolLiteral;
import io.gitlab.jfronny.muscript.ast.bool.BoolUnpack;
import io.gitlab.jfronny.muscript.ast.bool.Not;
import io.gitlab.jfronny.muscript.ast.bool.Or;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.context.IScope;
import io.gitlab.jfronny.muscript.ast.context.Script;
import io.gitlab.jfronny.muscript.ast.dynamic.At;
import io.gitlab.jfronny.muscript.ast.dynamic.Bind;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.Closure;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicAssign;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicCoerce;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicConditional;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.Equals;
import io.gitlab.jfronny.muscript.ast.dynamic.ExprGroup;
import io.gitlab.jfronny.muscript.ast.dynamic.Get;
import io.gitlab.jfronny.muscript.ast.dynamic.GetOrAt;
import io.gitlab.jfronny.muscript.ast.dynamic.ListLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.ObjectLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.This;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.ast.extensible.ExtensibleBoolExpr;
import io.gitlab.jfronny.muscript.ast.extensible.ExtensibleDynamicExpr;
import io.gitlab.jfronny.muscript.ast.extensible.ExtensibleNumberExpr;
import io.gitlab.jfronny.muscript.ast.extensible.ExtensibleStringExpr;
import io.gitlab.jfronny.muscript.ast.number.Add;
import io.gitlab.jfronny.muscript.ast.number.Divide;
import io.gitlab.jfronny.muscript.ast.number.GreaterThan;
import io.gitlab.jfronny.muscript.ast.number.Modulo;
import io.gitlab.jfronny.muscript.ast.number.Multiply;
import io.gitlab.jfronny.muscript.ast.number.Negate;
import io.gitlab.jfronny.muscript.ast.number.NumberAssign;
import io.gitlab.jfronny.muscript.ast.number.NumberConditional;
import io.gitlab.jfronny.muscript.ast.number.NumberLiteral;
import io.gitlab.jfronny.muscript.ast.number.NumberUnpack;
import io.gitlab.jfronny.muscript.ast.number.Power;
import io.gitlab.jfronny.muscript.ast.number.Subtract;
import io.gitlab.jfronny.muscript.ast.string.CharAt;
import io.gitlab.jfronny.muscript.ast.string.Concatenate;
import io.gitlab.jfronny.muscript.ast.string.StringAssign;
import io.gitlab.jfronny.muscript.ast.string.StringCoerce;
import io.gitlab.jfronny.muscript.ast.string.StringConditional;
import io.gitlab.jfronny.muscript.ast.string.StringLiteral;
import io.gitlab.jfronny.muscript.ast.string.StringUnpack;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.IDynamic;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.core.StackFrame;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.additional.libs.IntentionalException;
import io.gitlab.jfronny.muscript.data.additional.libs.SignatureDesyncException;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DCallable;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.DynamicTypeConversionException;
import io.gitlab.jfronny.muscript.data.dynamic.SignatureMismatchException;
import io.gitlab.jfronny.muscript.data.dynamic.context.DynamicSerializer;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.runtime.Except;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Runtime {
    public static Dynamic run(Script script, Scope scope) {
        return Runtime.evaluate(script.content(), scope);
    }

    public static Dynamic evaluate(Expr expr, Scope scope) {
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringExpr.class, NumberExpr.class, BoolExpr.class, DynamicExpr.class, NullLiteral.class}, (Object)expr3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                StringExpr e = (StringExpr)expr3;
                yield DFinal.of(Runtime.evaluate(e, scope));
            }
            case 1 -> {
                NumberExpr e = (NumberExpr)expr3;
                yield DFinal.of(Runtime.evaluate(e, scope));
            }
            case 2 -> {
                BoolExpr e = (BoolExpr)expr3;
                yield DFinal.of(Runtime.evaluate(e, scope));
            }
            case 3 -> {
                DynamicExpr e = (DynamicExpr)expr3;
                yield Runtime.evaluate(e, scope);
            }
            case 4 -> {
                NullLiteral e = (NullLiteral)expr3;
                yield new DNull();
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String evaluate(StringExpr expr, Scope scope) {
        Objects.requireNonNull(expr);
        try {
            Object index;
            Object left;
            Object object;
            StringExpr stringExpr = expr;
            Objects.requireNonNull(stringExpr);
            StringExpr stringExpr2 = stringExpr;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringLiteral.class, ExtensibleStringExpr.class, StringUnpack.class, StringCoerce.class, StringAssign.class, StringConditional.class, Concatenate.class, CharAt.class}, (Object)stringExpr2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    StringLiteral stringLiteral = (StringLiteral)stringExpr2;
                    try {
                        Object value;
                        Object object2;
                        Object object3 = stringLiteral.location();
                        CodeLocation location = object3;
                        object = object2 = (value = (object3 = stringLiteral.value()));
                        return object;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    ExtensibleStringExpr e = (ExtensibleStringExpr)stringExpr2;
                    String string = e.evaluate(scope);
                    object = string;
                    return object;
                }
                case 2: {
                    DynamicExpr inner;
                    StringUnpack stringUnpack = (StringUnpack)stringExpr2;
                    {
                        DynamicExpr dynamicExpr;
                        inner = dynamicExpr = stringUnpack.inner();
                    }
                    try {
                        Dynamic iv = Runtime.evaluate(inner, scope);
                        if (Dynamic.isNull(iv)) {
                            throw Except.locationalException((Expr)expr, "Cannot unpack null");
                        }
                        String string = iv.asString().getValue();
                        object = string;
                        return object;
                    }
                    catch (DynamicTypeConversionException e) {
                        throw Except.locationalException(e, expr);
                    }
                }
                case 3: {
                    StringCoerce stringCoerce = (StringCoerce)stringExpr2;
                    {
                        Expr expr2;
                        Expr inner = expr2 = stringCoerce.inner();
                        String string = DynamicSerializer.INSTANCE.serialize(Runtime.evaluate(inner, scope));
                        object = string;
                        return object;
                    }
                }
                case 4: {
                    Object value;
                    Object variable;
                    StringAssign stringAssign = (StringAssign)stringExpr2;
                    {
                        Object object4 = stringAssign.location();
                        CodeLocation location = object4;
                        variable = object4 = stringAssign.variable();
                        value = object4 = stringAssign.value();
                    }
                    String data = Runtime.evaluate((StringExpr)value, scope);
                    scope.set((String)variable, data);
                    String string = data;
                    object = string;
                    return object;
                }
                case 5: {
                    Object ifFalse;
                    Object ifTrue;
                    Object condition;
                    StringConditional stringConditional = (StringConditional)stringExpr2;
                    {
                        Object object5 = stringConditional.location();
                        CodeLocation location = object5;
                        condition = object5 = stringConditional.condition();
                        ifTrue = object5 = stringConditional.ifTrue();
                        ifFalse = object5 = stringConditional.ifFalse();
                    }
                    String string = Runtime.evaluate((BoolExpr)condition, scope) ? Runtime.evaluate((StringExpr)ifTrue, scope) : Runtime.evaluate((StringExpr)ifFalse, scope);
                    object = string;
                    return object;
                }
                case 6: {
                    Object right;
                    Object left2;
                    Concatenate concatenate = (Concatenate)stringExpr2;
                    {
                        Object object6 = concatenate.location();
                        CodeLocation location = object6;
                        left2 = object6 = concatenate.left();
                        right = object6 = concatenate.right();
                    }
                    String string = Runtime.evaluate((StringExpr)left2, scope) + Runtime.evaluate((StringExpr)right, scope);
                    object = string;
                    return object;
                }
                case 7: 
            }
            CharAt charAt = (CharAt)stringExpr2;
            {
                Object object7 = charAt.location();
                CodeLocation location = object7;
                left = object7 = charAt.left();
                index = object7 = charAt.index();
            }
            String l = Runtime.evaluate((StringExpr)left, scope);
            int i = (int)Runtime.evaluate((NumberExpr)index, scope);
            if (i < 0) throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
            if (i >= l.length()) {
                throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
            }
            String string = String.valueOf(l.charAt(i));
            object = string;
            return object;
        }
        catch (DynamicTypeConversionException e) {
            throw Except.locationalException(e, expr);
        }
        catch (NullPointerException e) {
            throw Except.locationalException((Expr)expr, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double evaluate(NumberExpr expr, Scope scope) {
        Objects.requireNonNull(expr);
        try {
            double d14;
            Object exponent;
            Object base;
            double d;
            NumberExpr numberExpr = expr;
            Objects.requireNonNull(numberExpr);
            NumberExpr numberExpr2 = numberExpr;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumberLiteral.class, ExtensibleNumberExpr.class, NumberUnpack.class, NumberAssign.class, NumberConditional.class, Add.class, Subtract.class, Negate.class, Multiply.class, Divide.class, Modulo.class, Power.class}, (Object)numberExpr2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    NumberLiteral numberLiteral = (NumberLiteral)numberExpr2;
                    try {
                        double d2;
                        double value;
                        double d3;
                        CodeLocation codeLocation;
                        CodeLocation location = codeLocation = numberLiteral.location();
                        d = d3 = (value = (d2 = numberLiteral.value()));
                        return d;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    double d4;
                    ExtensibleNumberExpr e = (ExtensibleNumberExpr)numberExpr2;
                    d = d4 = e.evaluate(scope);
                    return d;
                }
                case 2: {
                    DynamicExpr inner;
                    NumberUnpack numberUnpack = (NumberUnpack)numberExpr2;
                    {
                        DynamicExpr dynamicExpr;
                        inner = dynamicExpr = numberUnpack.inner();
                    }
                    try {
                        double d5;
                        Dynamic iv = Runtime.evaluate(inner, scope);
                        if (Dynamic.isNull(iv)) {
                            throw Except.locationalException((Expr)expr, "Cannot unpack null");
                        }
                        d = d5 = iv.asNumber().getValue().doubleValue();
                        return d;
                    }
                    catch (DynamicTypeConversionException e) {
                        throw Except.locationalException(e, expr);
                    }
                }
                case 3: {
                    double d6;
                    Object value;
                    Object variable;
                    NumberAssign numberAssign = (NumberAssign)numberExpr2;
                    {
                        Object object = numberAssign.location();
                        CodeLocation location = object;
                        variable = object = numberAssign.variable();
                        value = object = numberAssign.value();
                    }
                    double data = Runtime.evaluate((NumberExpr)value, scope);
                    scope.set((String)variable, data);
                    d = d6 = data;
                    return d;
                }
                case 4: {
                    double d7;
                    Object ifFalse;
                    Object ifTrue;
                    Object condition;
                    NumberConditional numberConditional = (NumberConditional)numberExpr2;
                    {
                        Object object = numberConditional.location();
                        CodeLocation location = object;
                        condition = object = numberConditional.condition();
                        ifTrue = object = numberConditional.ifTrue();
                        ifFalse = object = numberConditional.ifFalse();
                    }
                    d = d7 = Runtime.evaluate((BoolExpr)condition, scope) ? Runtime.evaluate((NumberExpr)ifTrue, scope) : Runtime.evaluate((NumberExpr)ifFalse, scope);
                    return d;
                }
                case 5: {
                    double d8;
                    Object addend;
                    Object augend;
                    Add add = (Add)numberExpr2;
                    {
                        Object object = add.location();
                        CodeLocation location = object;
                        augend = object = add.augend();
                        addend = object = add.addend();
                    }
                    d = d8 = Runtime.evaluate((NumberExpr)augend, scope) + Runtime.evaluate((NumberExpr)addend, scope);
                    return d;
                }
                case 6: {
                    double d9;
                    Object subtrahend;
                    Object minuend;
                    Subtract subtract = (Subtract)numberExpr2;
                    {
                        Object object = subtract.location();
                        CodeLocation location = object;
                        minuend = object = subtract.minuend();
                        subtrahend = object = subtract.subtrahend();
                    }
                    d = d9 = Runtime.evaluate((NumberExpr)minuend, scope) - Runtime.evaluate((NumberExpr)subtrahend, scope);
                    return d;
                }
                case 7: {
                    double d10;
                    Object inner;
                    Negate negate = (Negate)numberExpr2;
                    {
                        Object object = negate.location();
                        CodeLocation location = object;
                        inner = object = negate.inner();
                    }
                    d = d10 = -Runtime.evaluate((NumberExpr)inner, scope);
                    return d;
                }
                case 8: {
                    double d11;
                    Object multiplicand;
                    Object multiplier;
                    Multiply multiply = (Multiply)numberExpr2;
                    {
                        Object object = multiply.location();
                        CodeLocation location = object;
                        multiplier = object = multiply.multiplier();
                        multiplicand = object = multiply.multiplicand();
                    }
                    d = d11 = Runtime.evaluate((NumberExpr)multiplier, scope) * Runtime.evaluate((NumberExpr)multiplicand, scope);
                    return d;
                }
                case 9: {
                    double d12;
                    Object divisor;
                    Object dividend;
                    Divide divide = (Divide)numberExpr2;
                    {
                        Object object = divide.location();
                        CodeLocation location = object;
                        dividend = object = divide.dividend();
                        divisor = object = divide.divisor();
                    }
                    d = d12 = Runtime.evaluate((NumberExpr)dividend, scope) / Runtime.evaluate((NumberExpr)divisor, scope);
                    return d;
                }
                case 10: {
                    double d13;
                    Object divisor;
                    Object dividend;
                    Modulo modulo = (Modulo)numberExpr2;
                    {
                        Object object = modulo.location();
                        CodeLocation location = object;
                        dividend = object = modulo.dividend();
                        divisor = object = modulo.divisor();
                    }
                    d = d13 = Runtime.evaluate((NumberExpr)dividend, scope) % Runtime.evaluate((NumberExpr)divisor, scope);
                    return d;
                }
                case 11: 
            }
            Power power = (Power)numberExpr2;
            {
                Object object = power.location();
                CodeLocation location = object;
                base = object = power.base();
                exponent = object = power.exponent();
            }
            d = d14 = Math.pow(Runtime.evaluate((NumberExpr)base, scope), Runtime.evaluate((NumberExpr)exponent, scope));
            return d;
        }
        catch (DynamicTypeConversionException e) {
            throw Except.locationalException(e, expr);
        }
        catch (ArithmeticException | NullPointerException e) {
            throw Except.locationalException((Expr)expr, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean evaluate(BoolExpr expr, Scope scope) {
        Objects.requireNonNull(expr);
        try {
            Object right;
            Object left;
            BoolExpr boolExpr = expr;
            Objects.requireNonNull(boolExpr);
            BoolExpr boolExpr2 = boolExpr;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolLiteral.class, ExtensibleBoolExpr.class, BoolUnpack.class, BoolAssign.class, BoolConditional.class, And.class, Or.class, Not.class, Equals.class, GreaterThan.class}, (Object)boolExpr2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    boolean bl;
                    BoolLiteral boolLiteral = (BoolLiteral)boolExpr2;
                    try {
                        boolean bl2;
                        boolean value;
                        boolean bl3;
                        CodeLocation codeLocation;
                        CodeLocation location = codeLocation = boolLiteral.location();
                        bl = bl3 = (value = (bl2 = boolLiteral.value()));
                        return bl;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    boolean bl4;
                    ExtensibleBoolExpr e = (ExtensibleBoolExpr)boolExpr2;
                    boolean bl = bl4 = e.evaluate(scope);
                    return bl;
                }
                case 2: {
                    DynamicExpr inner;
                    boolean bl;
                    BoolUnpack boolUnpack = (BoolUnpack)boolExpr2;
                    {
                        DynamicExpr dynamicExpr;
                        inner = dynamicExpr = boolUnpack.inner();
                    }
                    try {
                        boolean bl5;
                        Dynamic iv = Runtime.evaluate(inner, scope);
                        if (Dynamic.isNull(iv)) {
                            throw Except.locationalException((Expr)expr, "Cannot unpack null");
                        }
                        bl = bl5 = iv.asBool().getValue().booleanValue();
                        return bl;
                    }
                    catch (DynamicTypeConversionException e) {
                        throw Except.locationalException(e, expr);
                    }
                }
                case 3: {
                    boolean bl6;
                    Object value;
                    Object variable;
                    BoolAssign boolAssign = (BoolAssign)boolExpr2;
                    {
                        Object object = boolAssign.location();
                        CodeLocation location = object;
                        variable = object = boolAssign.variable();
                        value = object = boolAssign.value();
                    }
                    boolean data = Runtime.evaluate((BoolExpr)value, scope);
                    scope.set((String)variable, data);
                    boolean bl = bl6 = data;
                    return bl;
                }
                case 4: {
                    boolean bl7;
                    Object ifFalse;
                    Object ifTrue;
                    Object condition;
                    BoolConditional boolConditional = (BoolConditional)boolExpr2;
                    {
                        Object object = boolConditional.location();
                        CodeLocation location = object;
                        condition = object = boolConditional.condition();
                        ifTrue = object = boolConditional.ifTrue();
                        ifFalse = object = boolConditional.ifFalse();
                    }
                    boolean bl = bl7 = Runtime.evaluate((BoolExpr)condition, scope) ? Runtime.evaluate((BoolExpr)ifTrue, scope) : Runtime.evaluate((BoolExpr)ifFalse, scope);
                    return bl;
                }
                case 5: {
                    Object right2;
                    Object left2;
                    And and = (And)boolExpr2;
                    {
                        Object object = and.location();
                        CodeLocation location = object;
                        left2 = object = and.left();
                        right2 = object = and.right();
                    }
                    if (!Runtime.evaluate((BoolExpr)left2, scope)) return false;
                    if (!Runtime.evaluate((BoolExpr)right2, scope)) return false;
                    return true;
                }
                case 6: {
                    Object right3;
                    Object left3;
                    Or or = (Or)boolExpr2;
                    {
                        Object object = or.location();
                        CodeLocation location = object;
                        left3 = object = or.left();
                        right3 = object = or.right();
                    }
                    if (Runtime.evaluate((BoolExpr)left3, scope)) return true;
                    if (!Runtime.evaluate((BoolExpr)right3, scope)) return false;
                    return true;
                }
                case 7: {
                    Object inner;
                    Not not = (Not)boolExpr2;
                    {
                        Object object = not.location();
                        CodeLocation location = object;
                        inner = object = not.inner();
                    }
                    if (Runtime.evaluate((BoolExpr)inner, scope)) return false;
                    return true;
                }
                case 8: {
                    boolean bl11;
                    Object right4;
                    Object left4;
                    Equals equals = (Equals)boolExpr2;
                    {
                        Object object = equals.location();
                        CodeLocation location = object;
                        left4 = object = equals.left();
                        right4 = object = equals.right();
                    }
                    boolean bl = bl11 = Objects.equals(Runtime.evaluate((Expr)left4, scope), Runtime.evaluate((Expr)right4, scope));
                    return bl;
                }
                case 9: 
            }
            GreaterThan greaterThan = (GreaterThan)boolExpr2;
            {
                Object object = greaterThan.location();
                CodeLocation location = object;
                left = object = greaterThan.left();
                right = object = greaterThan.right();
            }
            if (!(Runtime.evaluate((NumberExpr)left, scope) > Runtime.evaluate((NumberExpr)right, scope))) return false;
            return true;
        }
        catch (DynamicTypeConversionException e) {
            throw Except.locationalException(e, expr);
        }
        catch (NullPointerException e) {
            throw Except.locationalException((Expr)expr, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dynamic evaluate(DynamicExpr expr, Scope scope) {
        Objects.requireNonNull(expr);
        try {
            LinkedHashMap result;
            Dynamic dynamic;
            DynamicExpr dynamicExpr = expr;
            Objects.requireNonNull(dynamicExpr);
            DynamicExpr dynamicExpr2 = dynamicExpr;
            int n = 0;
            block49: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicLiteral.class, ExtensibleDynamicExpr.class, DynamicCoerce.class, DynamicAssign.class, DynamicConditional.class, This.class, Variable.class, Get.class, At.class, GetOrAt.class, Bind.class, Call.class, Closure.class, ExprGroup.class, ListLiteral.class, ObjectLiteral.class}, (Object)dynamicExpr2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Object value;
                        DynamicLiteral dynamicLiteral = (DynamicLiteral)dynamicExpr2;
                        try {
                            Object object = dynamicLiteral.location();
                            CodeLocation location = object;
                            value = object = dynamicLiteral.content();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        Dynamic dynamic2 = Runtime.coerce(expr, (IDynamic)value);
                        dynamic = dynamic2;
                        return dynamic;
                    }
                    case 1: {
                        ExtensibleDynamicExpr e2 = (ExtensibleDynamicExpr)dynamicExpr2;
                        Dynamic dynamic3 = Runtime.coerce(e2, e2.evaluate(scope));
                        dynamic = dynamic3;
                        return dynamic;
                    }
                    case 2: {
                        int n2;
                        Expr expr2;
                        DynamicCoerce dynamicCoerce = (DynamicCoerce)dynamicExpr2;
                        {
                            expr2 = dynamicCoerce.inner();
                            n2 = 0;
                        }
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringExpr.class, NumberExpr.class, BoolExpr.class, DynamicExpr.class, NullLiteral.class}, (Object)expr2, n2)) {
                            case 0: {
                                StringExpr inner = (StringExpr)expr2;
                                DString dString = DFinal.of(Runtime.evaluate(inner, scope));
                                dynamic = dString;
                                return dynamic;
                            }
                            case 1: {
                                NumberExpr inner = (NumberExpr)expr2;
                                DNumber dNumber = DFinal.of(Runtime.evaluate(inner, scope));
                                dynamic = dNumber;
                                return dynamic;
                            }
                            case 2: {
                                BoolExpr inner = (BoolExpr)expr2;
                                DBool dBool = DFinal.of(Runtime.evaluate(inner, scope));
                                dynamic = dBool;
                                return dynamic;
                            }
                            case 3: {
                                DynamicExpr inner = (DynamicExpr)expr2;
                                Dynamic dynamic4 = Runtime.evaluate(inner, scope);
                                dynamic = dynamic4;
                                return dynamic;
                            }
                            case 4: {
                                NullLiteral inner = (NullLiteral)expr2;
                                DNull dNull = new DNull();
                                dynamic = dNull;
                                return dynamic;
                            }
                        }
                        n = 3;
                        continue block49;
                    }
                    case 3: {
                        Object value;
                        Object variable;
                        Expr expr2 = (DynamicAssign)dynamicExpr2;
                        {
                            Object object = ((DynamicAssign)expr2).location();
                            CodeLocation location = object;
                            variable = object = ((DynamicAssign)expr2).variable();
                            value = object = ((DynamicAssign)expr2).value();
                        }
                        Dynamic data = Runtime.evaluate((DynamicExpr)value, scope);
                        scope.set((String)variable, data.isCallable() ? data.asCallable().named((String)variable) : data);
                        Dynamic dynamic5 = data;
                        dynamic = dynamic5;
                        return dynamic;
                    }
                    case 4: {
                        Object ifFalse;
                        Object ifTrue;
                        Object condition;
                        DynamicConditional dynamicConditional = (DynamicConditional)dynamicExpr2;
                        {
                            Object object = dynamicConditional.location();
                            CodeLocation location = object;
                            condition = object = dynamicConditional.condition();
                            ifTrue = object = dynamicConditional.ifTrue();
                            ifFalse = object = dynamicConditional.ifFalse();
                        }
                        Dynamic dynamic6 = Runtime.evaluate((BoolExpr)condition, scope) ? Runtime.evaluate((DynamicExpr)ifTrue, scope) : Runtime.evaluate((DynamicExpr)ifFalse, scope);
                        dynamic = dynamic6;
                        return dynamic;
                    }
                    case 5: {
                        Scope scope2;
                        This e3 = (This)dynamicExpr2;
                        dynamic = scope2 = scope;
                        return dynamic;
                    }
                    case 6: {
                        Object name;
                        Variable variable = (Variable)dynamicExpr2;
                        {
                            Object object = variable.location();
                            CodeLocation location = object;
                            name = object = variable.name();
                        }
                        if (!scope.has((String)name)) throw Except.locationalException((Expr)expr, "Variable " + (String)name + " not found");
                        Dynamic dynamic7 = scope.get((String)name);
                        dynamic = dynamic7;
                        return dynamic;
                    }
                    case 7: {
                        String n3;
                        Object name;
                        Object leftExpr;
                        Get get = (Get)dynamicExpr2;
                        {
                            Object object = get.location();
                            CodeLocation location = object;
                            leftExpr = object = get.left();
                            name = object = get.name();
                        }
                        Dynamic left = Runtime.evaluate((DynamicExpr)leftExpr, scope);
                        if (Dynamic.isNull(left)) {
                            throw Except.locationalException((Expr)expr, "Could not get \"" + Runtime.evaluate((StringExpr)name, scope) + "\" because left is null");
                        }
                        if (!left.isObject()) {
                            throw Except.locationalException((Expr)expr, "Cannot get from non-object");
                        }
                        DObject o = left.asObject();
                        if (!o.has(n3 = Runtime.evaluate(ExprUtils.asString((Expr)name), scope))) {
                            throw Except.locationalException((Expr)expr, "Object does not contain \"" + n3 + "\"");
                        }
                        Dynamic dynamic8 = o.get(n3);
                        dynamic = dynamic8;
                        return dynamic;
                    }
                    case 8: {
                        Object index;
                        Object leftExpr;
                        At at = (At)dynamicExpr2;
                        {
                            Object object = at.location();
                            CodeLocation location = object;
                            leftExpr = object = at.left();
                            index = object = at.index();
                        }
                        Dynamic left = Runtime.evaluate((DynamicExpr)leftExpr, scope);
                        if (Dynamic.isNull(left)) {
                            throw Except.locationalException((Expr)expr, "Could not get \"" + Runtime.evaluate((NumberExpr)index, scope) + "\" because left is null");
                        }
                        if (!left.isList()) {
                            if (left.isObject()) {
                                String n4;
                                DObject o = left.asObject();
                                if (!o.has(n4 = Runtime.evaluate(ExprUtils.asString((Expr)index), scope))) {
                                    throw Except.locationalException((Expr)expr, "Object does not contain \"" + n4 + "\"");
                                }
                                Dynamic dynamic9 = o.get(n4);
                                dynamic = dynamic9;
                                return dynamic;
                            }
                            if (!left.isString()) throw Except.locationalException((Expr)expr, "Get/At operator only supports lists, objects and strings");
                            String l = left.asString().getValue();
                            int i = (int)Runtime.evaluate((NumberExpr)index, scope);
                            if (i < 0) throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
                            if (i >= l.length()) {
                                throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
                            }
                            DString dString = DFinal.of(String.valueOf(l.charAt(i)));
                            dynamic = dString;
                            return dynamic;
                        }
                        DList l = left.asList();
                        int idx = (int)Runtime.evaluate((NumberExpr)index, scope);
                        if (idx < 0) throw Except.locationalException((Expr)expr, "Index " + idx + " is out of range for list with size " + l.size());
                        if (idx >= l.size()) {
                            throw Except.locationalException((Expr)expr, "Index " + idx + " is out of range for list with size " + l.size());
                        }
                        Dynamic dynamic10 = l.get(idx);
                        dynamic = dynamic10;
                        return dynamic;
                    }
                    case 9: {
                        Object nameOrIndex;
                        Object leftExpr;
                        GetOrAt getOrAt = (GetOrAt)dynamicExpr2;
                        {
                            Object object = getOrAt.location();
                            CodeLocation location = object;
                            leftExpr = object = getOrAt.left();
                            nameOrIndex = object = getOrAt.nameOrIndex();
                        }
                        Dynamic left = Runtime.evaluate((DynamicExpr)leftExpr, scope);
                        Dynamic right = Runtime.evaluate((Expr)nameOrIndex, scope);
                        if (Dynamic.isNull(left)) {
                            throw Except.locationalException((Expr)expr, "Could not get \"" + String.valueOf(Runtime.evaluate((Expr)nameOrIndex, scope)) + "\" because left is null");
                        }
                        if (left.isList() && right.isNumber()) {
                            DList l = left.asList();
                            int idx = (int)Runtime.evaluate(ExprUtils.asNumber((Expr)nameOrIndex), scope);
                            if (idx < 0) throw Except.locationalException((Expr)expr, "Index " + idx + " is out of range for list with size " + l.size());
                            if (idx >= l.size()) {
                                throw Except.locationalException((Expr)expr, "Index " + idx + " is out of range for list with size " + l.size());
                            }
                            Dynamic dynamic11 = l.get(idx);
                            dynamic = dynamic11;
                            return dynamic;
                        }
                        if (left.isObject()) {
                            String n5;
                            DObject o = left.asObject();
                            if (!o.has(n5 = right.asString().getValue())) {
                                throw Except.locationalException((Expr)expr, "Object does not contain \"" + n5 + "\"");
                            }
                            Dynamic dynamic12 = o.get(n5);
                            dynamic = dynamic12;
                            return dynamic;
                        }
                        if (!left.isString()) throw new DynamicTypeConversionException("object, list or string", left);
                        if (!right.isNumber()) throw new DynamicTypeConversionException("object, list or string", left);
                        String l = left.asString().getValue();
                        int i = (int)Runtime.evaluate(ExprUtils.asNumber((Expr)nameOrIndex), scope);
                        if (i < 0) throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
                        if (i >= l.length()) {
                            throw Except.locationalException((Expr)expr, "Index " + i + " is out of range for string with length " + l.length());
                        }
                        DString dString = DFinal.of(String.valueOf(l.charAt(i)));
                        dynamic = dString;
                        return dynamic;
                    }
                    case 10: {
                        Object parameter;
                        Object callable;
                        Bind bind = (Bind)dynamicExpr2;
                        {
                            Object object = bind.location();
                            CodeLocation location = object;
                            callable = object = bind.callable();
                            parameter = object = bind.parameter();
                        }
                        Dynamic param = Runtime.evaluate((DynamicExpr)parameter, scope);
                        DCallable clb = Runtime.evaluate((DynamicExpr)callable, scope).asCallable();
                        DCallable dCallable = DFinal.of("<bind>", args -> {
                            LinkedList<Dynamic> argsWithParameter = new LinkedList<Dynamic>((Collection<Dynamic>)args.getValue());
                            argsWithParameter.addFirst(param);
                            return clb.call(DFinal.of(argsWithParameter));
                        }, () -> expr);
                        dynamic = dCallable;
                        return dynamic;
                    }
                    case 11: {
                        DList arg;
                        DCallable dc;
                        Call e4 = (Call)dynamicExpr2;
                        try {
                            Dynamic lv = Runtime.evaluate(e4.callable(), scope);
                            if (Dynamic.isNull(lv)) {
                                throw Except.locationalException((Expr)expr, "Cannot invoke null");
                            }
                            dc = lv.asCallable();
                            arg = DFinal.of((Dynamic[])e4.arguments().stream().flatMap(a -> Runtime.evaluate(a, scope)).toArray(Dynamic[]::new));
                        }
                        catch (RuntimeException ex) {
                            throw Except.locationalException(expr, "Could not perform call successfully", ex);
                        }
                        try {
                            Dynamic dynamic13 = dc.call(arg);
                            dynamic = dynamic13;
                            return dynamic;
                        }
                        catch (LocationalException le) {
                            throw le.appendStack(new StackFrame.Raw(expr.location().file(), dc.getName(), e4.callable().location().chStart()));
                        }
                        catch (IntentionalException | SignatureDesyncException | SignatureMismatchException ex) {
                            throw new LocationalException(expr.location(), ex.getMessage(), ex);
                        }
                        catch (RuntimeException ex) {
                            throw Except.locationalException(expr, ex.getMessage(), ex);
                        }
                    }
                    case 12: {
                        Object finish;
                        List<Expr> steps;
                        boolean variadic;
                        Object boundArgs;
                        Closure closure = (Closure)dynamicExpr2;
                        {
                            boolean bl;
                            Object object = closure.location();
                            CodeLocation location = object;
                            boundArgs = object = closure.boundArgs();
                            variadic = bl = closure.variadic();
                            Object object2 = closure.steps();
                            steps = object2;
                            finish = object2 = closure.finish();
                        }
                        DCallable dCallable = DFinal.of((DType)Runtime.getSignature((List<String>)boundArgs, variadic), null, arg_0 -> Runtime.lambda$evaluate$4((List)boundArgs, variadic, expr, scope, steps, (DynamicExpr)finish, arg_0), () -> expr);
                        dynamic = dCallable;
                        return dynamic;
                    }
                    case 13: {
                        Object object;
                        Scope fork;
                        boolean shouldFork;
                        Object packedArgs;
                        Object finish;
                        Object steps;
                        ExprGroup exprGroup = (ExprGroup)dynamicExpr2;
                        {
                            boolean bl;
                            Object object3 = exprGroup.location();
                            CodeLocation location = object3;
                            steps = object3 = exprGroup.steps();
                            finish = object3 = exprGroup.finish();
                            packedArgs = object3 = exprGroup.packedArgs();
                            shouldFork = bl = exprGroup.fork();
                            Scope scope2 = fork = shouldFork ? scope.fork() : scope;
                        }
                        if (shouldFork && packedArgs instanceof ExprGroup.PackedArgs) {
                            LinkedList<Dynamic> from;
                            boolean variadic;
                            List<Object> boundArgs;
                            List<Call.Argument> sourceArgs;
                            object = packedArgs;
                            {
                                boolean bl2;
                                List<Object> list = ((ExprGroup.PackedArgs)object).from();
                                sourceArgs = list;
                                boundArgs = list = ((ExprGroup.PackedArgs)object).to();
                                variadic = bl2 = ((ExprGroup.PackedArgs)object).variadic();
                                from = new LinkedList<Dynamic>();
                            }
                            for (Call.Argument arg : sourceArgs) {
                                Dynamic data = Runtime.evaluate(arg.value(), scope);
                                if (arg.variadic()) {
                                    from.addAll((Collection<Dynamic>)data.asList().getValue());
                                    continue;
                                }
                                from.add(data);
                            }
                            int ac = from.size();
                            int ae = boundArgs.size();
                            if (variadic) {
                                --ae;
                            }
                            if (ac < ae) {
                                throw Except.locationalException((Expr)expr, "Invoked with too few arguments (expected " + ae + " but got " + ac + ")");
                            }
                            if (!variadic && ac > ae) {
                                throw Except.locationalException((Expr)expr, "Invoked with too many arguments (expected " + ae + " but got " + ac + ")");
                            }
                            for (int i = 0; i < ae; ++i) {
                                fork.set((String)boundArgs.get(i), (Dynamic)from.get(i));
                            }
                            if (variadic) {
                                fork.set((String)boundArgs.getLast(), IntStream.range(ae, ac).mapToObj(from::get).toList());
                            }
                        }
                        object = steps.iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                Dynamic dynamic14 = Runtime.evaluate((DynamicExpr)finish, fork);
                                dynamic = dynamic14;
                                return dynamic;
                            }
                            Expr step = (Expr)object.next();
                            Runtime.evaluate(step, fork);
                        }
                    }
                    case 14: {
                        Object elements;
                        ListLiteral listLiteral = (ListLiteral)dynamicExpr2;
                        {
                            Object object = listLiteral.location();
                            CodeLocation location = object;
                            elements = object = listLiteral.elements();
                        }
                        DList dList = DFinal.of(elements.stream().map(e -> Runtime.evaluate(e, scope)).toList());
                        dynamic = dList;
                        return dynamic;
                    }
                    case 15: 
                }
                break;
            }
            ObjectLiteral objectLiteral = (ObjectLiteral)dynamicExpr2;
            {
                Object ac = objectLiteral.location();
                CodeLocation location = ac;
                Object content = ac = objectLiteral.content();
                result = new LinkedHashMap();
                content.forEach((k, v) -> result.put(k, Runtime.evaluate(v, scope)));
            }
            DObject dObject = DFinal.of(result);
            dynamic = dObject;
            return dynamic;
        }
        catch (DynamicTypeConversionException e5) {
            throw Except.locationalException(e5, expr);
        }
        catch (NullPointerException e6) {
            throw Except.locationalException((Expr)expr, e6);
        }
    }

    private static DTypeCallable getSignature(List<String> boundArgs, boolean variadic) {
        LinkedList<DTypeCallable.Arg> args = new LinkedList<DTypeCallable.Arg>();
        for (int i = 0; i < boundArgs.size(); ++i) {
            args.add(new DTypeCallable.Arg(boundArgs.get(i), null, variadic && i == boundArgs.size() - 1));
        }
        return new DTypeCallable(args, null);
    }

    private static Stream<? extends Dynamic> evaluate(Call.Argument argument, Scope scope) {
        return argument.variadic() ? Runtime.evaluate(argument.value(), scope).asList().getValue().stream() : Stream.of(Runtime.evaluate(argument.value(), scope));
    }

    public static Dynamic coerce(DynamicExpr expr, IDynamic value) {
        IDynamic iDynamic = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dynamic.class}, (Object)iDynamic, n)) {
            case -1 -> null;
            case 0 -> {
                Dynamic d;
                yield d = (Dynamic)iDynamic;
            }
            default -> throw Except.locationalException((Expr)expr, "Unsupported implementation of Dynamic");
        };
    }

    public static Scope coerce(Expr expr, IScope scope) {
        IScope iScope = scope;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Scope.class}, (Object)iScope, n)) {
            case -1 -> null;
            case 0 -> {
                Scope s;
                yield s = (Scope)iScope;
            }
            default -> throw Except.locationalException(expr, "Unsupported implementation of Scope");
        };
    }

    public static DCallable bind(Script script, Scope scope) {
        return DFinal.of("<root>", args -> {
            scope.set("args", (Dynamic)args);
            return Runtime.run(script, scope);
        }, script::content);
    }

    private static /* synthetic */ Dynamic lambda$evaluate$4(List boundArgs, boolean variadic, DynamicExpr expr, Scope scope, List steps, DynamicExpr finish, DList args) {
        int ac = args.size();
        int ae = boundArgs.size();
        if (variadic) {
            --ae;
        }
        if (ac < ae) {
            throw Except.locationalException((Expr)expr, "Invoked with too few arguments (expected " + ae + " but got " + ac + ")");
        }
        if (!variadic && ac > ae) {
            throw Except.locationalException((Expr)expr, "Invoked with too many arguments (expected " + ae + " but got " + ac + ")");
        }
        Scope fork = scope.fork();
        for (int i = 0; i < ae; ++i) {
            fork.set((String)boundArgs.get(i), args.get(i));
        }
        if (variadic) {
            fork.set((String)boundArgs.getLast(), IntStream.range(ae, ac).mapToObj(args::get).toList());
        }
        for (Expr step : steps) {
            Runtime.evaluate(step, fork);
        }
        return Runtime.evaluate(finish, fork);
    }
}

