/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.parser.lexer;

import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.parser.VersionedComponent;
import io.gitlab.jfronny.muscript.parser.lexer.Token;
import java.util.Objects;

public class LexerImpl
extends VersionedComponent {
    public final String file;
    public Token token;
    public String lexeme;
    public char ch;
    public final String source;
    public int start;
    public int current;
    public boolean passedNewline = false;

    public LexerImpl(MuScriptVersion version, String source) {
        this(version, source, null);
    }

    public LexerImpl(MuScriptVersion version, String source, String file) {
        super(version);
        this.source = Objects.requireNonNull(source);
        this.file = file;
    }

    public CodeLocation location() {
        return new CodeLocation(this.start, this.current - 1, this.source, this.file);
    }

    public void next() {
        this.start = this.current;
        this.passedNewline = false;
        if (this.isAtEnd()) {
            this.createToken(Token.EOF);
            return;
        }
        this.skipWhitespaceAndComments();
        if (this.isAtEnd()) {
            this.createToken(Token.EOF);
            return;
        }
        char c = this.advance();
        if (this.isDigit(c)) {
            this.number();
        } else if (this.isIdentifier(c)) {
            this.identifier(false);
        } else {
            switch (c) {
                case '\"': 
                case '\'': {
                    this.string(c);
                    break;
                }
                case '`': {
                    this.identifier(true);
                    break;
                }
                case '=': {
                    if (this.match('=')) {
                        this.createToken(Token.EqualEqual);
                        break;
                    }
                    this.createToken(Token.Assign);
                    break;
                }
                case '!': {
                    this.createToken(this.match('=') ? Token.BangEqual : Token.Bang);
                    break;
                }
                case '+': {
                    this.createToken(Token.Plus);
                    break;
                }
                case '-': {
                    if (this.match('>')) {
                        this.createToken(Token.Arrow);
                        break;
                    }
                    this.createToken(Token.Minus);
                    break;
                }
                case '*': {
                    this.createToken(Token.Star);
                    break;
                }
                case '/': {
                    this.createToken(Token.Slash);
                    break;
                }
                case '%': {
                    this.createToken(Token.Percentage);
                    break;
                }
                case '>': {
                    this.createToken(this.match('=') ? Token.GreaterEqual : Token.Greater);
                    break;
                }
                case '<': {
                    this.createToken(this.match('=') ? Token.LessEqual : Token.Less);
                    break;
                }
                case '&': {
                    this.createToken(Token.And);
                    break;
                }
                case '|': {
                    this.createToken(this.match('|') ? Token.Concat : Token.Or);
                    break;
                }
                case '^': {
                    this.createToken(Token.UpArrow);
                    break;
                }
                case '.': {
                    if (this.match('.')) {
                        if (this.match('.')) {
                            this.createToken(Token.Ellipsis);
                            break;
                        }
                        this.createToken(Token.Error, "Unexpected '..', did you mean '...'?");
                        break;
                    }
                    this.createToken(Token.Dot);
                    break;
                }
                case ',': {
                    this.createToken(Token.Comma);
                    break;
                }
                case '?': {
                    this.createToken(Token.QuestionMark);
                    break;
                }
                case ':': {
                    this.createToken(this.match(':') ? Token.DoubleColon : Token.Colon);
                    break;
                }
                case '(': {
                    this.createToken(Token.LeftParen);
                    break;
                }
                case ')': {
                    this.createToken(Token.RightParen);
                    break;
                }
                case '[': {
                    this.createToken(Token.LeftBracket);
                    break;
                }
                case ']': {
                    this.createToken(Token.RightBracket);
                    break;
                }
                case '{': {
                    this.createToken(Token.LeftBrace);
                    break;
                }
                case '}': {
                    this.createToken(Token.RightBrace);
                    break;
                }
                case ';': {
                    this.createToken(Token.Semicolon);
                    this.passedNewline = true;
                    break;
                }
                default: {
                    this.unexpected();
                }
            }
        }
    }

    private void string(char stringChar) {
        while (!this.isAtEnd() && this.peek() != stringChar) {
            this.advance();
        }
        if (this.isAtEnd()) {
            this.createToken(Token.Error, "Unterminated expression");
        } else {
            this.advance();
            this.createToken(Token.String, this.source.substring(this.start + 1, this.current - 1));
        }
    }

    private void number() {
        while (this.isDigit(this.peek())) {
            this.advance();
        }
        if (this.peek() == '.' && this.isDigit(this.peekNext())) {
            this.advance();
            while (this.isDigit(this.peek())) {
                this.advance();
            }
        }
        this.createToken(Token.Number);
    }

    private void identifier(boolean explicit) {
        if (explicit) {
            while (!this.isAtEnd() && this.peek() != '`') {
                this.advance();
            }
            if (this.isAtEnd()) {
                this.createToken(Token.Error, "Unterminated expression");
            } else {
                this.advance();
                this.createToken(Token.Identifier, this.source.substring(this.start + 1, this.current - 1));
            }
        } else {
            char c;
            while (!this.isAtEnd() && (this.isIdentifier(c = this.peek()) || this.isDigit(c))) {
                this.advance();
            }
            this.createToken(Token.Identifier);
            switch (this.lexeme) {
                case "null": {
                    this.token = Token.Null;
                    break;
                }
                case "true": {
                    this.token = Token.True;
                    break;
                }
                case "false": {
                    this.token = Token.False;
                }
            }
        }
    }

    private void skipWhitespaceAndComments() {
        block9: while (true) {
            if (this.isAtEnd()) {
                return;
            }
            switch (this.peek()) {
                case '\t': 
                case ' ': {
                    this.advance();
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    this.advance();
                    this.passedNewline = true;
                    continue block9;
                }
                case '/': {
                    switch (this.peekNext()) {
                        case '/': {
                            while (true) {
                                if (this.isAtEnd() || this.peek() == '\r' || this.peek() == '\n') continue block9;
                                this.advance();
                            }
                        }
                        case '*': {
                            this.advance();
                            this.advance();
                            while (!(this.isAtEnd() || this.peek() == '*' && this.peekNext() == '/')) {
                                this.advance();
                            }
                            if (this.isAtEnd()) continue block9;
                            this.advance();
                            this.advance();
                            continue block9;
                        }
                    }
                    this.start = this.current;
                    return;
                }
            }
            break;
        }
        this.start = this.current;
    }

    private void unexpected() {
        this.createToken(Token.Error, "Unexpected character");
    }

    private void createToken(Token token, String lexeme) {
        this.token = token;
        this.lexeme = lexeme;
    }

    private void createToken(Token token) {
        this.createToken(token, this.source.substring(this.start, this.current));
    }

    private boolean match(char expected) {
        if (this.isAtEnd()) {
            return false;
        }
        if (this.source.charAt(this.current) != expected) {
            return false;
        }
        this.advance();
        return true;
    }

    private char advance() {
        this.ch = this.source.charAt(this.current++);
        return this.ch;
    }

    private char peek() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.current);
    }

    private char peekNext() {
        if (this.current + 1 >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.current + 1);
    }

    private boolean isAtEnd() {
        return this.current >= this.source.length();
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    public String toString() {
        return this.source.substring(0, this.start) + "[" + this.source.substring(this.start, this.current) + "]" + this.source.substring(this.current);
    }
}

