/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.parser.lexer;

import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.parser.lexer.Lexer;
import io.gitlab.jfronny.muscript.parser.lexer.LexerImpl;
import org.jetbrains.annotations.Nullable;

public class LegacyLexer
implements Lexer {
    private final LexerImpl backend;
    private Lexer.Token previous = null;

    public LegacyLexer(MuScriptVersion version, String source) {
        this(new LexerImpl(version, source));
    }

    public LegacyLexer(MuScriptVersion version, String source, String file) {
        this(new LexerImpl(version, source, file));
    }

    public LegacyLexer(LexerImpl backend) {
        this.backend = backend;
    }

    @Override
    public CodeLocation location() {
        return this.backend.location();
    }

    @Override
    public MuScriptVersion version() {
        return this.backend.getComponentVersion();
    }

    @Override
    public boolean wasNewlinePassed() {
        return this.backend.passedNewline;
    }

    @Override
    public Lexer.Token getPrevious() {
        return this.previous;
    }

    @Override
    public Lexer.Token advance() {
        this.backend.next();
        this.previous = new Lexer.Token(this.backend.lexeme, this.backend.token, this.backend.start, this.backend.current, this.backend.ch, new CodeLocation(this.backend.start, this.backend.current - 1, this.backend.source, this.backend.file));
        return this.previous;
    }

    @Override
    @Nullable
    public String getSource() {
        return this.backend.source;
    }

    @Override
    @Nullable
    public String getFile() {
        return this.backend.file;
    }
}

