/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.parser;

import io.gitlab.jfronny.muscript.core.MuUtil;

public class StarScriptIngester {
    private static final System.Logger LOGGER = System.getLogger("MuScript");

    public static String starScriptToMu(String source) {
        StringBuilder result = new StringBuilder();
        StringBuilder currbuf = new StringBuilder();
        State state = State.Surrounding;
        block17: for (char c : source.toCharArray()) {
            switch (state.ordinal()) {
                case 0: {
                    if (c == '{') {
                        if (!currbuf.isEmpty()) {
                            if (!result.isEmpty()) {
                                result.append(" || ");
                            }
                            result.append(MuUtil.enquote(currbuf.toString()));
                        }
                        currbuf = new StringBuilder();
                        state = State.UnquotedInner;
                        continue block17;
                    }
                    currbuf.append(c);
                    continue block17;
                }
                case 1: {
                    switch (c) {
                        case '}': {
                            if (!currbuf.isEmpty()) {
                                if (!result.isEmpty()) {
                                    result.append(" || ");
                                }
                                result.append("(").append((CharSequence)currbuf).append(")");
                            }
                            currbuf = new StringBuilder();
                            state = State.Surrounding;
                            continue block17;
                        }
                        case '\'': {
                            currbuf.append(c);
                            state = State.SingleQuoteInner;
                            continue block17;
                        }
                        case '\"': {
                            currbuf.append(c);
                            state = State.DoubleQuoteInner;
                            continue block17;
                        }
                    }
                    currbuf.append(c);
                    continue block17;
                }
                case 2: {
                    currbuf.append(c);
                    if (c != '\'') continue block17;
                    state = State.UnquotedInner;
                    continue block17;
                }
                case 3: {
                    currbuf.append(c);
                    if (c != '\"') continue block17;
                    state = State.UnquotedInner;
                }
            }
        }
        if (!currbuf.isEmpty() && !result.isEmpty()) {
            result.append(" || ");
        }
        switch (state.ordinal()) {
            case 0: {
                if (currbuf.isEmpty()) break;
                result.append(MuUtil.enquote(currbuf.toString()));
                break;
            }
            case 1: {
                LOGGER.log(System.Logger.Level.WARNING, "Starscript code segment improperly closed, closing automatically");
                if (currbuf.isEmpty()) break;
                result.append("(").append((CharSequence)currbuf).append(")");
                break;
            }
            case 2: {
                LOGGER.log(System.Logger.Level.WARNING, "Quote in starscript swallows ending, completing with closing quote");
                if (currbuf.isEmpty()) break;
                result.append("(").append((CharSequence)currbuf).append("')");
                break;
            }
            case 3: {
                LOGGER.log(System.Logger.Level.WARNING, "Quote in starscript swallows ending, completing with closing quote");
                if (currbuf.isEmpty()) break;
                result.append("(").append((CharSequence)currbuf).append("\")");
            }
        }
        return result.toString();
    }

    static enum State {
        Surrounding,
        UnquotedInner,
        SingleQuoteInner,
        DoubleQuoteInner;

    }
}

