/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.parser;

import io.gitlab.jfronny.muscript.ast.BoolExpr;
import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.NumberExpr;
import io.gitlab.jfronny.muscript.ast.StringExpr;
import io.gitlab.jfronny.muscript.ast.bool.And;
import io.gitlab.jfronny.muscript.ast.bool.Not;
import io.gitlab.jfronny.muscript.ast.bool.Or;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.context.Script;
import io.gitlab.jfronny.muscript.ast.context.TypeMismatchException;
import io.gitlab.jfronny.muscript.ast.dynamic.Bind;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.Closure;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicAssign;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicConditional;
import io.gitlab.jfronny.muscript.ast.dynamic.Equals;
import io.gitlab.jfronny.muscript.ast.dynamic.Get;
import io.gitlab.jfronny.muscript.ast.dynamic.GetOrAt;
import io.gitlab.jfronny.muscript.ast.dynamic.ObjectLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.This;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.ast.number.Add;
import io.gitlab.jfronny.muscript.ast.number.Divide;
import io.gitlab.jfronny.muscript.ast.number.GreaterThan;
import io.gitlab.jfronny.muscript.ast.number.Modulo;
import io.gitlab.jfronny.muscript.ast.number.Multiply;
import io.gitlab.jfronny.muscript.ast.number.Negate;
import io.gitlab.jfronny.muscript.ast.number.Power;
import io.gitlab.jfronny.muscript.ast.number.Subtract;
import io.gitlab.jfronny.muscript.ast.string.CharAt;
import io.gitlab.jfronny.muscript.ast.string.Concatenate;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.core.PrettyPrintError;
import io.gitlab.jfronny.muscript.core.SourceFS;
import io.gitlab.jfronny.muscript.parser.VersionedComponent;
import io.gitlab.jfronny.muscript.parser.lexer.LegacyLexer;
import io.gitlab.jfronny.muscript.parser.lexer.Lexer;
import io.gitlab.jfronny.muscript.parser.lexer.LexerImpl;
import io.gitlab.jfronny.muscript.parser.lexer.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Parser
extends VersionedComponent {
    private final Lexer lexer;
    private Lexer.Token previous = null;

    public static Expr parse(MuScriptVersion version, String source) {
        return Parser.parse(version, source, null);
    }

    public static Expr parse(MuScriptVersion version, String source, String file) {
        return new Parser(new LegacyLexer(version, source, file)).parse();
    }

    public static Script parseScript(MuScriptVersion version, String source) {
        return Parser.parseScript(version, source, null);
    }

    public static Script parseScript(MuScriptVersion version, String source, String file) {
        return new Parser(new LegacyLexer(version, source, file)).parseScript();
    }

    public static Script parseMultiScript(MuScriptVersion version, String startFile, SourceFS filesystem) {
        return new Script(Parser.parseMultiScript(version, startFile, filesystem, new HashSet<String>()).stream().flatMap(Script::stream).toList());
    }

    private static List<Script> parseMultiScript(MuScriptVersion version, String startFile, SourceFS filesystem, Set<String> alreadyIncluded) {
        alreadyIncluded.add(startFile);
        boolean isIncludes = true;
        StringBuilder src = new StringBuilder();
        LinkedList<Script> includes = new LinkedList<Script>();
        int row = 0;
        String includePrefix = "#include ";
        for (String s : filesystem.read(startFile).split("\n")) {
            ++row;
            if (s.isBlank()) {
                src.append("\n");
                continue;
            }
            if (s.startsWith("#include ")) {
                if (isIncludes) {
                    String file = s.substring("#include ".length());
                    src.append("// include ").append(file).append("\n");
                    if (alreadyIncluded.contains(file)) continue;
                    includes.addAll(Parser.parseMultiScript(version, file, filesystem, alreadyIncluded));
                    continue;
                }
                throw new ParseException(PrettyPrintError.builder().setLocation(new PrettyPrintError.Location(s, 0, row), new PrettyPrintError.Location(s, s.length() - 1, row)).setMessage("Includes MUST be located at the top of the file").build());
            }
            isIncludes = false;
            src.append(s).append("\n");
        }
        includes.add(Parser.parseScript(version, src.toString(), startFile));
        return includes;
    }

    public Parser(LexerImpl lexer) {
        this(new LegacyLexer(lexer));
    }

    public Parser(Lexer lexer) {
        super(lexer.version());
        this.lexer = lexer;
    }

    public Expr parse() {
        this.advance();
        Expr expr = this.expression();
        if (!this.isAtEnd() && this.version.contains(MuScriptVersion.V2)) {
            throw new ParseException(PrettyPrintError.builder(this.lexer.location()).setMessage("Unexpected element after end of expression").build());
        }
        return expr;
    }

    public Script parseScript() {
        this.advance();
        LinkedList<Expr> expressions = new LinkedList<Expr>();
        while (!this.isAtEnd()) {
            expressions.add(this.expression());
            if (!(!this.lexer.wasNewlinePassed() & !this.match(Token.Semicolon) & !this.isAtEnd() & this.version.contains(MuScriptVersion.V3))) continue;
            throw this.error("Either a semicolon or a new line must separate expressions in scripts");
        }
        if (expressions.isEmpty()) {
            throw new ParseException(PrettyPrintError.builder(this.lexer.location()).setMessage("Missing any elements in closure").build());
        }
        return new Script(expressions);
    }

    private Expr expression() {
        try {
            return this.conditional();
        }
        catch (RuntimeException e) {
            if (e instanceof ParseException) {
                throw e;
            }
            if (e instanceof LocationalException) {
                LocationalException le = (LocationalException)e;
                throw new ParseException(le.asPrintable(), le.getCause());
            }
            throw this.error(e.getMessage());
        }
    }

    private Expr conditional() {
        Expr expr = this.and();
        if (this.match(Token.QuestionMark)) {
            CodeLocation location = this.previous.location();
            Expr trueExpr = this.expression();
            this.consume(Token.Colon, "Expected ':' after first part of condition");
            Expr falseExpr = this.expression();
            expr = new DynamicConditional(location, this.asBool(expr), ExprUtils.asDynamic(trueExpr), ExprUtils.asDynamic(falseExpr));
        }
        return expr;
    }

    private Expr and() {
        Expr expr = this.or();
        while (this.match(Token.And)) {
            CodeLocation location = this.previous.location();
            Expr right = this.or();
            expr = new And(location, this.asBool(expr), this.asBool(right));
        }
        return expr;
    }

    private Expr or() {
        Expr expr = this.equality();
        while (this.match(Token.Or)) {
            CodeLocation location = this.previous.location();
            Expr right = this.equality();
            expr = new Or(location, this.asBool(expr), this.asBool(right));
        }
        return expr;
    }

    private Expr equality() {
        Expr expr = this.concat();
        while (this.match(Token.EqualEqual, Token.BangEqual)) {
            Token op = this.previous.token();
            CodeLocation location = this.previous.location();
            Expr right = this.concat();
            Record e = new Equals(location, expr, right);
            if (op == Token.BangEqual) {
                e = new Not(location, (BoolExpr)((Object)e));
            }
            expr = e;
        }
        return expr;
    }

    private Expr concat() {
        Expr expr = this.comparison();
        while (this.match(Token.Concat)) {
            CodeLocation location = this.previous.location();
            Expr right = this.comparison();
            expr = new Concatenate(location, this.asString(expr), this.asString(right));
        }
        return expr;
    }

    private Expr comparison() {
        Expr expr = this.term();
        while (this.match(Token.Greater, Token.GreaterEqual, Token.Less, Token.LessEqual)) {
            Token op = this.previous.token();
            CodeLocation location = this.previous.location();
            NumberExpr right = this.asNumber(this.term());
            expr = switch (op) {
                case Token.Greater -> new GreaterThan(location, this.asNumber(expr), right);
                case Token.GreaterEqual -> new Not(location, new GreaterThan(location, right, this.asNumber(expr)));
                case Token.Less -> new GreaterThan(location, right, this.asNumber(expr));
                case Token.LessEqual -> new Not(location, new GreaterThan(location, this.asNumber(expr), right));
                default -> throw new IllegalStateException();
            };
        }
        return expr;
    }

    private Expr term() {
        Expr expr = this.factor();
        while (this.match(Token.Plus, Token.Minus)) {
            Token op = this.previous.token();
            CodeLocation location = this.previous.location();
            NumberExpr right = this.asNumber(this.factor());
            expr = switch (op) {
                case Token.Plus -> new Add(location, this.asNumber(expr), right);
                case Token.Minus -> new Subtract(location, this.asNumber(expr), right);
                default -> throw new IllegalStateException();
            };
        }
        return expr;
    }

    private Expr factor() {
        Expr expr = this.exp();
        while (this.match(Token.Star, Token.Slash, Token.Percentage)) {
            Token op = this.previous.token();
            CodeLocation location = this.previous.location();
            NumberExpr right = this.asNumber(this.exp());
            expr = switch (op) {
                case Token.Star -> new Multiply(location, this.asNumber(expr), right);
                case Token.Slash -> new Divide(location, this.asNumber(expr), right);
                case Token.Percentage -> new Modulo(location, this.asNumber(expr), right);
                default -> throw new IllegalStateException();
            };
        }
        return expr;
    }

    private Expr exp() {
        Expr expr = this.unary();
        while (this.match(Token.UpArrow)) {
            CodeLocation location = this.previous.location();
            NumberExpr right = this.asNumber(this.unary());
            expr = new Power(location, this.asNumber(expr), right);
        }
        return expr;
    }

    private Expr unary() {
        if (this.match(Token.Bang, Token.Minus)) {
            Token op = this.previous.token();
            CodeLocation location = this.previous.location();
            Expr right = this.unary();
            return switch (op) {
                case Token.Bang -> new Not(location, this.asBool(right));
                case Token.Minus -> new Negate(location, this.asNumber(right));
                default -> throw new IllegalStateException();
            };
        }
        return this.call();
    }

    private Expr call() {
        Expr expr = this.primary();
        expr = this.finishImplicitCallWithLambda(this.asDynamic(expr));
        while (this.match(Token.LeftParen, Token.Dot, Token.LeftBracket, Token.DoubleColon)) {
            CodeLocation location = this.previous.location();
            expr = switch (this.previous.token()) {
                case Token.LeftParen -> this.finishCall(location, expr);
                case Token.Dot -> {
                    Lexer.Token name = this.consume(Token.Identifier, "Expected field/method name after '.'");
                    yield this.finishImplicitCallWithLambda(new Get(location, this.asDynamic(expr), Expr.literal(name.location(), name.lexeme())));
                }
                case Token.DoubleColon -> {
                    DynamicExpr callable;
                    if (this.match(Token.Identifier)) {
                        callable = new Variable(this.previous.location(), this.previous.lexeme());
                    } else if (this.match(Token.LeftParen)) {
                        Expr expr1 = this.expression();
                        callable = ExprUtils.asDynamic(expr1);
                        this.consume(Token.RightParen, "Expected ')' after expression");
                    } else {
                        throw this.error("Bind operator requires right side to be a literal identifier or to be wrapped in parentheses.");
                    }
                    yield this.finishImplicitCallWithLambda(new Bind(location, callable, ExprUtils.asDynamic(expr)));
                }
                case Token.LeftBracket -> {
                    Record v1;
                    if (expr instanceof StringExpr) {
                        StringExpr se = (StringExpr)expr;
                        v1 = new CharAt(location, se, this.asNumber(this.expression()));
                    } else {
                        v1 = new GetOrAt(location, this.asDynamic(expr), this.expression());
                    }
                    expr = v1;
                    this.consume(Token.RightBracket, "Expected closing bracket");
                    yield expr;
                }
                default -> throw new IllegalStateException();
            };
        }
        return expr;
    }

    private Expr finishImplicitCallWithLambda(Expr callable) {
        while (this.version.contains(MuScriptVersion.V4) && this.check(Token.LeftBrace) && !this.lexer.wasNewlinePassed()) {
            this.advance();
            Closure clj = this.readClosure();
            List<Call.Argument> args = List.of(new Call.Argument(clj, false));
            callable = new Call(clj.location(), this.asDynamic(callable), args);
        }
        return callable;
    }

    private Expr finishCall(CodeLocation location, Expr callee) {
        ArrayList<Call.Argument> args = new ArrayList<Call.Argument>(2);
        if (!this.check(Token.RightParen)) {
            do {
                args.add(new Call.Argument(this.asDynamic(this.expression()), this.match(Token.Ellipsis)));
            } while (this.match(Token.Comma));
        }
        this.consume(Token.RightParen, "Expected ')' after function arguments");
        if (this.version.contains(MuScriptVersion.V4) && this.check(Token.LeftBrace) && !this.lexer.wasNewlinePassed()) {
            this.advance();
            args.add(new Call.Argument(this.readClosure(), false));
        }
        return new Call(location, this.asDynamic(callee), args);
    }

    private Expr primary() {
        if (this.match(Token.Null)) {
            return Expr.literalNull(this.previous.location());
        }
        if (this.match(Token.String)) {
            return Expr.literal(this.previous.location(), this.previous.lexeme());
        }
        if (this.match(Token.True, Token.False)) {
            return Expr.literal(this.previous.location(), this.previous.lexeme().equals("true"));
        }
        if (this.match(Token.Number)) {
            return Expr.literal(this.previous.location(), Double.parseDouble(this.previous.lexeme()));
        }
        if (this.match(Token.Identifier)) {
            CodeLocation location = this.previous.location();
            String name = this.previous.lexeme();
            if (this.match(Token.Assign)) {
                if (name.equals("this")) {
                    throw this.error("Cannot assign to 'this' keyword");
                }
                Expr expr = this.expression();
                return new DynamicAssign(location, name, ExprUtils.asDynamic(expr));
            }
            if (name.equals("this")) {
                return new This(location);
            }
            return new Variable(location, name);
        }
        if (this.match(Token.LeftParen)) {
            Expr expr = this.expression();
            this.consume(Token.RightParen, "Expected ')' after expression");
            return expr;
        }
        if (this.match(Token.LeftBrace)) {
            int start = this.previous.start();
            if (this.match(Token.Arrow)) {
                return this.finishClosure(start, null, false);
            }
            if (this.match(Token.RightBrace)) {
                return new ObjectLiteral(this.location(start, this.previous.start()), Map.of());
            }
            this.consume(Token.Identifier, "Expected arrow or identifier as first element in closure or object");
            String first = this.previous.lexeme();
            if (this.check(Token.Arrow)) {
                return this.finishClosure(start, first, false);
            }
            if (this.match(Token.Ellipsis)) {
                return this.finishClosure(start, first, true);
            }
            if (this.check(Token.Comma)) {
                return this.finishClosure(start, first, false);
            }
            if (this.match(Token.Assign)) {
                Expr expr = this.expression();
                return this.finishObject(start, first, ExprUtils.asDynamic(expr));
            }
            throw this.error("Unexpected");
        }
        throw this.error("Expected expression.");
    }

    private Closure readClosure() {
        int start = this.previous.start();
        if (this.match(Token.Arrow)) {
            return this.finishClosure(start, null, false);
        }
        this.consume(Token.Identifier, "Closure arguments MUST be identifiers");
        String first = this.previous.lexeme();
        if (this.check(Token.Arrow)) {
            return this.finishClosure(start, first, false);
        }
        if (this.match(Token.Ellipsis)) {
            return this.finishClosure(start, first, true);
        }
        if (this.check(Token.Comma)) {
            return this.finishClosure(start, first, false);
        }
        throw this.error("Unexpected");
    }

    private Closure finishClosure(int start, @Nullable String firstArg, boolean firstVariadic) {
        LinkedList<String> boundArgs = new LinkedList<String>();
        boolean variadic = false;
        if (firstArg != null) {
            boundArgs.add(firstArg);
            if (firstVariadic) {
                this.consume(Token.Arrow, "Variadic argument MUST be the last argument");
                variadic = true;
            } else {
                while (!this.match(Token.Arrow)) {
                    this.consume(Token.Comma, "Closure parameters MUST be comma-seperated");
                    this.consume(Token.Identifier, "Closure arguments MUST be identifiers");
                    boundArgs.add(this.previous.lexeme());
                    if (!this.match(Token.Ellipsis)) continue;
                    variadic = true;
                    this.consume(Token.Arrow, "Variadic argument MUST be the last argument");
                    break;
                }
            }
        }
        LinkedList<Expr> expressions = new LinkedList<Expr>();
        while (!this.match(Token.RightBrace)) {
            expressions.add(this.expression());
            if (!(!this.lexer.wasNewlinePassed() & !this.match(Token.Semicolon) & this.version.contains(MuScriptVersion.V3))) continue;
            if (this.match(Token.RightBrace)) break;
            throw this.error("Either a semicolon or a new line must separate expressions in closures");
        }
        int end = this.previous.start();
        return new Closure(this.location(start, end), boundArgs, variadic, expressions);
    }

    private Expr finishObject(int start, @Nullable String firstArg, @Nullable DynamicExpr firstValue) {
        LinkedHashMap<String, DynamicExpr> content = new LinkedHashMap<String, DynamicExpr>();
        content.put(firstArg, firstValue);
        while (this.match(Token.Comma)) {
            this.consume(Token.Identifier, "Object element MUST start with an identifier");
            String name = this.previous.lexeme();
            this.consume(Token.Assign, "Object element name and value MUST be seperated with '='");
            Expr expr = this.expression();
            content.put(name, ExprUtils.asDynamic(expr));
        }
        this.consume(Token.RightBrace, "Expected end of object");
        return new ObjectLiteral(this.location(start, this.previous.start()), content);
    }

    private BoolExpr asBool(Expr expression) {
        try {
            return ExprUtils.asBool(expression);
        }
        catch (TypeMismatchException e) {
            throw this.error(e.getMessage(), expression);
        }
    }

    private NumberExpr asNumber(Expr expression) {
        try {
            return ExprUtils.asNumber(expression);
        }
        catch (TypeMismatchException e) {
            throw this.error(e.getMessage(), expression);
        }
    }

    private StringExpr asString(Expr expression) {
        try {
            return ExprUtils.asString(expression);
        }
        catch (TypeMismatchException e) {
            throw this.error(e.getMessage(), expression);
        }
    }

    private DynamicExpr asDynamic(Expr expression) {
        return ExprUtils.asDynamic(expression);
    }

    private CodeLocation location(int chStart, int chEnd) {
        return new CodeLocation(chStart, chEnd, this.lexer.getSource(), this.lexer.getFile());
    }

    private ParseException error(String message) {
        int loc = this.lexer.getPrevious().current() - 1;
        return new ParseException(PrettyPrintError.builder(this.location(loc, loc)).setMessage(message).build());
    }

    private ParseException error(String message, Expr expr) {
        return new ParseException(PrettyPrintError.builder(expr.location()).setMessage(message).build());
    }

    private Lexer.Token consume(Token token, String message) {
        if (this.check(token)) {
            return this.advance();
        }
        throw this.error(message + " but got " + String.valueOf((Object)this.lexer.getPrevious().token()));
    }

    private boolean match(Token ... tokens) {
        for (Token token : tokens) {
            if (!this.check(token)) continue;
            this.advance();
            return true;
        }
        return false;
    }

    private boolean check(Token token) {
        if (this.isAtEnd()) {
            return false;
        }
        return this.lexer.getPrevious().token() == token;
    }

    private Lexer.Token advance() {
        this.previous = this.lexer.getPrevious();
        this.lexer.advance();
        if (this.lexer.getPrevious().token() == Token.Error) {
            throw this.error(this.lexer.getPrevious().lexeme());
        }
        return this.previous;
    }

    private boolean isAtEnd() {
        return this.lexer.getPrevious().token() == Token.EOF;
    }

    public static class ParseException
    extends RuntimeException {
        public final PrettyPrintError error;

        public ParseException(PrettyPrintError error) {
            super(error.toString());
            this.error = error;
        }

        public ParseException(PrettyPrintError error, Throwable cause) {
            super(error.toString(), cause);
            this.error = error;
        }
    }
}

