/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.dynamic.type;

import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeAnd;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeGeneric;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeSum;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class TypeMatcher {
    public static boolean match(DType fn, List<DType> args) {
        if (fn instanceof DTypeAnd) {
            DTypeAnd ds = (DTypeAnd)fn;
            for (DType element : ds.elements()) {
                if (!TypeMatcher.match(element, args)) continue;
                return true;
            }
            return false;
        }
        if (fn instanceof DTypeCallable) {
            DTypeCallable ds = (DTypeCallable)fn;
            return TypeMatcher.match(ds, args);
        }
        return false;
    }

    public static boolean match(DTypeCallable fn, List<DType> args) {
        return fn.from() == null || TypeMatcher.match(fn.from(), args);
    }

    public static boolean match(List<DTypeCallable.Arg> declared, List<DType> provided) {
        return TypeMatcher.match(declared, provided, new MatchScope());
    }

    private static boolean match(List<DTypeCallable.Arg> declared, List<DType> provided, MatchScope scope) {
        if (declared.isEmpty()) {
            return provided.isEmpty();
        }
        if (provided.isEmpty()) {
            return declared.stream().allMatch(DTypeCallable.Arg::variadic);
        }
        if (!declared.get(0).variadic()) {
            DType ct = declared.get(0).type();
            DType pt = provided.get(0);
            declared = declared.subList(1, declared.size());
            provided = provided.subList(1, provided.size());
            if (ct == null) {
                return TypeMatcher.match(declared, provided, scope);
            }
            Result r = TypeMatcher.match(ct, pt, scope);
            if (r == Result.MATCH) {
                return TypeMatcher.match(declared, provided, scope);
            }
            if (r == Result.FAILED) {
                return false;
            }
            for (Map<Integer, DType> s2 : ((Result.PossibleMatch)r).possibleHydrations()) {
                if (!TypeMatcher.match(declared, provided, scope.fork(s2))) continue;
                return true;
            }
            return false;
        }
        DType cArg = declared.get(0).type();
        List<DTypeCallable.Arg> nextDeclared = declared.subList(1, declared.size());
        while (!provided.isEmpty()) {
            if (TypeMatcher.match(nextDeclared, provided, scope)) {
                return true;
            }
            DType dt = provided.get(0);
            provided = provided.subList(1, provided.size());
            if (cArg == null) continue;
            Result r = TypeMatcher.match(cArg, dt, scope);
            if (r == Result.FAILED) {
                TypeMatcher.match(cArg, dt, scope);
                return false;
            }
            if (r == Result.MATCH) continue;
            for (Map<Integer, DType> s2 : ((Result.PossibleMatch)r).possibleHydrations()) {
                if (!TypeMatcher.match(declared, provided, scope.fork(s2))) continue;
                return true;
            }
            return false;
        }
        return TypeMatcher.match(nextDeclared, provided, scope);
    }

    private static Result match(DType declared, @Nullable DType provided, MatchScope scope) {
        if (declared instanceof DTypeGeneric) {
            DTypeGeneric dg = (DTypeGeneric)declared;
            if (scope.hydrations.containsKey(dg.index())) {
                Result r = TypeMatcher.match(scope.hydrations.get(dg.index()), provided, scope);
                if (r == Result.FAILED) {
                    if (provided != null) {
                        return new Result.PossibleMatch(Set.of(Map.of(dg.index(), scope.hydrations.get(dg.index()).or(provided))));
                    }
                    return Result.MATCH;
                }
                return r;
            }
            return new Result.PossibleMatch(provided == null ? Set.of(Map.of()) : Set.of(Map.of(dg.index(), provided)));
        }
        if (provided instanceof DTypeSum) {
            DTypeSum dc = (DTypeSum)provided;
            Result currentResult = Result.MATCH;
            for (DType element : dc.elements()) {
                currentResult = currentResult.and(TypeMatcher.match(declared, element, scope), scope);
            }
            return currentResult;
        }
        if (provided instanceof DTypeAnd) {
            DTypeAnd dc = (DTypeAnd)provided;
            if (!(declared instanceof DTypeAnd)) {
                Result currentResult = Result.FAILED;
                for (DType element : dc.elements()) {
                    currentResult = currentResult.or(TypeMatcher.match(declared, element, scope), scope);
                }
                return currentResult;
            }
        }
        if (declared instanceof DTypeCallable) {
            DTypeCallable dg = (DTypeCallable)declared;
            if (!(provided instanceof DTypeCallable)) {
                return Result.FAILED;
            }
            DTypeCallable dc = (DTypeCallable)provided;
            Result.Const currentResult = Result.MATCH;
            if (dg.from() != null) {
                if (dc.from() == null) {
                    return Result.MATCH;
                }
                List<DTypeCallable.Arg> dgf = dg.from();
                List<DTypeCallable.Arg> list = dc.from();
            }
            if (dg.to() == null) {
                return currentResult;
            }
            if (dc.to() == null) {
                return currentResult;
            }
            return currentResult.and(TypeMatcher.match(dg.to(), dc.to(), scope), scope);
        }
        if (declared instanceof DTypeList) {
            DTypeList dg = (DTypeList)declared;
            if (!(provided instanceof DTypeList)) {
                return Result.FAILED;
            }
            DTypeList dc = (DTypeList)provided;
            if (dg.entryType() == null) {
                return Result.MATCH;
            }
            return TypeMatcher.match(dg.entryType(), dc.entryType(), scope);
        }
        if (declared instanceof DTypeObject) {
            DTypeObject dg = (DTypeObject)declared;
            if (!(provided instanceof DTypeObject)) {
                return Result.FAILED;
            }
            DTypeObject dc = (DTypeObject)provided;
            if (dg.entryType() == null) {
                return Result.MATCH;
            }
            return TypeMatcher.match(dg.entryType(), dc.entryType(), scope);
        }
        if (declared instanceof DTypePrimitive) {
            DTypePrimitive dg = (DTypePrimitive)declared;
            if (!(provided instanceof DTypePrimitive)) {
                return Result.FAILED;
            }
            DTypePrimitive dc = (DTypePrimitive)provided;
            return dg == dc ? Result.MATCH : Result.FAILED;
        }
        if (declared instanceof DTypeSum) {
            DTypeSum dg = (DTypeSum)declared;
            Result currentResult = Result.FAILED;
            for (DType element : dg.elements()) {
                currentResult = currentResult.or(TypeMatcher.match(element, provided, scope), scope);
            }
            return currentResult;
        }
        if (declared instanceof DTypeAnd) {
            DTypeAnd dg = (DTypeAnd)declared;
            Result currentResult = Result.MATCH;
            for (DType element : dg.elements()) {
                currentResult = currentResult.and(TypeMatcher.match(element, provided, scope), scope);
            }
            return currentResult;
        }
        throw new IllegalArgumentException("Unexpected DType implementation: " + String.valueOf(declared.getClass()));
    }

    private record MatchScope(Map<Integer, DType> hydrations) {
        public MatchScope() {
            this(Map.of());
        }

        public MatchScope fork(Map<Integer, DType> additional) {
            LinkedHashMap<Integer, DType> fork = new LinkedHashMap<Integer, DType>(this.hydrations);
            fork.putAll(additional);
            return new MatchScope(Map.copyOf(fork));
        }
    }

    private static sealed interface Result {
        public static final Const FAILED = Const.FAILED;
        public static final Const MATCH = Const.MATCH;

        default public Result and(Result other, MatchScope scope) {
            if (other instanceof PossibleMatch) {
                PossibleMatch pm = (PossibleMatch)other;
                return pm.and(this, scope);
            }
            if (other == FAILED) {
                return FAILED;
            }
            if (other == MATCH) {
                return this;
            }
            throw new IllegalArgumentException("Unexpected Result implementation");
        }

        default public Result or(Result other, MatchScope scope) {
            if (other instanceof PossibleMatch) {
                PossibleMatch pm = (PossibleMatch)other;
                return pm.and(this, scope);
            }
            if (other == FAILED) {
                return this;
            }
            if (other == MATCH) {
                return MATCH;
            }
            throw new IllegalArgumentException("Unexpected Result implementation");
        }

        public record PossibleMatch(Set<Map<Integer, DType>> possibleHydrations) implements Result
        {
            @Override
            public Result and(Result result, MatchScope scope) {
                if (result == FAILED) {
                    return FAILED;
                }
                if (result == MATCH) {
                    return this;
                }
                Set neu = ((PossibleMatch)result).possibleHydrations.stream().flatMap(left -> this.possibleHydrations.stream().filter(right -> Stream.concat(left.keySet().stream(), right.keySet().stream()).filter(left::containsKey).filter(right::containsKey).allMatch(s -> {
                    Result r = TypeMatcher.match((DType)left.get(s), (DType)right.get(s), scope);
                    if (r == FAILED) {
                        return false;
                    }
                    if (r == MATCH) {
                        return true;
                    }
                    throw new IllegalArgumentException("Unexpected post-match Result implementation");
                }))).collect(Collectors.toCollection(LinkedHashSet::new));
                if (neu.isEmpty()) {
                    return FAILED;
                }
                return new PossibleMatch(neu);
            }

            @Override
            public Result or(Result other, MatchScope scope) {
                if (other == FAILED) {
                    return this;
                }
                Stream oth = other == MATCH ? Stream.of(Map.of()) : ((PossibleMatch)other).possibleHydrations.stream();
                return new PossibleMatch(Stream.concat(this.possibleHydrations.stream(), oth).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        }

        public static enum Const implements Result
        {
            FAILED,
            MATCH;

        }
    }
}

