/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.dynamic.type;

import io.gitlab.jfronny.commons.data.ImmCollection;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeAnd;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public record DTypeSum(Set<DType> elements) implements DType
{
    public DTypeSum(Set<DType> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Cannot create sum type without elements");
        }
        LinkedHashSet<DType> simple = new LinkedHashSet<DType>();
        LinkedHashSet<DType> list = new LinkedHashSet<DType>();
        LinkedHashSet<DType> object = new LinkedHashSet<DType>();
        LinkedList<DType> toProcess = new LinkedList<DType>(elements);
        while (!toProcess.isEmpty()) {
            DType type = (DType)toProcess.remove();
            if (type instanceof DTypePrimitive || type instanceof DTypeAnd || type instanceof DTypeCallable) {
                simple.add(type);
                continue;
            }
            if (type instanceof DTypeList) {
                DTypeList u = (DTypeList)type;
                list.add(u.entryType());
                continue;
            }
            if (type instanceof DTypeObject) {
                DTypeObject u = (DTypeObject)type;
                object.add(u.entryType());
                continue;
            }
            if (type instanceof DTypeSum) {
                DTypeSum u = (DTypeSum)type;
                toProcess.addAll(u.elements);
                continue;
            }
            throw new IllegalArgumentException("Unexpected DType implementation: " + String.valueOf(type.getClass()));
        }
        if (!list.isEmpty()) {
            simple.add(new DTypeList(list.contains(null) ? null : new DTypeSum(list)));
        }
        if (!object.isEmpty()) {
            simple.add(new DTypeObject(object.contains(null) ? null : new DTypeSum(object)));
        }
        this.elements = ImmCollection.copyOf(simple);
    }

    @Override
    public String toString() {
        return DType.toString(this);
    }
}

