/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.dynamic.type;

import io.gitlab.jfronny.commons.data.ImmCollection;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeGeneric;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeSum;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public record DTypeAnd(Set<DType> elements) implements DType
{
    public DTypeAnd(Set<DType> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Cannot create union type without elements");
        }
        LinkedHashSet<DType> simple = new LinkedHashSet<DType>();
        LinkedHashSet<DType> list = new LinkedHashSet<DType>();
        LinkedHashSet<DType> object = new LinkedHashSet<DType>();
        boolean foundNullList = false;
        boolean foundNullObject = false;
        LinkedList<DType> toProcess = new LinkedList<DType>(elements);
        while (!toProcess.isEmpty()) {
            DType type = (DType)toProcess.remove();
            if (type instanceof DTypePrimitive || type instanceof DTypeSum || type instanceof DTypeCallable || type instanceof DTypeGeneric) {
                simple.add(type);
                continue;
            }
            if (type instanceof DTypeList) {
                DTypeList u = (DTypeList)type;
                if (u.entryType() == null) {
                    if (!foundNullList) {
                        simple.add(new DTypeList(null));
                    }
                    foundNullList = true;
                    continue;
                }
                list.add(u.entryType());
                continue;
            }
            if (type instanceof DTypeObject) {
                DTypeObject u = (DTypeObject)type;
                if (u.entryType() == null) {
                    if (!foundNullObject) {
                        simple.add(new DTypeObject(null));
                    }
                    foundNullObject = true;
                    continue;
                }
                object.add(u.entryType());
                continue;
            }
            if (type instanceof DTypeAnd) {
                DTypeAnd u = (DTypeAnd)type;
                toProcess.addAll(u.elements);
                continue;
            }
            throw new IllegalArgumentException("Unexpected DType implementation: " + String.valueOf(type.getClass()));
        }
        if (!list.isEmpty()) {
            simple.add(new DTypeList(new DTypeAnd(list)));
        }
        if (!object.isEmpty()) {
            simple.add(new DTypeObject(new DTypeAnd(object)));
        }
        this.elements = ImmCollection.copyOf(simple);
    }

    @Override
    public String toString() {
        return DType.toString(this);
    }
}

