/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.dynamic.type;

import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeAnd;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeGeneric;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeSum;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public sealed interface DType
permits DTypeCallable, DTypeGeneric, DTypeList, DTypeObject, DTypePrimitive, DTypeSum, DTypeAnd {
    public static String toString(@Nullable DType type) {
        return DType.toString(type, false);
    }

    default public DType or(DType alternative) {
        return new DTypeSum(Set.of(this, alternative));
    }

    default public DType and(DType additional) {
        return new DTypeAnd(Set.of(this, additional));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(@Nullable DType type, boolean wrapComplex) {
        Object object;
        DType dType = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DTypePrimitive.class, DTypeGeneric.class, DTypeList.class, DTypeObject.class, DTypeCallable.class, DTypeSum.class, DTypeAnd.class}, (Object)dType, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                return "any";
            }
            case 0: {
                DTypePrimitive t = (DTypePrimitive)dType;
                switch (t) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BOOL: {
                        return "bool";
                    }
                    case NUMBER: {
                        return "number";
                    }
                    case STRING: {
                        return "string";
                    }
                    case NULL: 
                }
                return "null";
            }
            case 1: {
                int index;
                DTypeGeneric dTypeGeneric = (DTypeGeneric)dType;
                try {
                    int n2;
                    index = n2 = dTypeGeneric.index();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = "T" + index;
                return object;
            }
            case 2: {
                DType entryType;
                DTypeList dTypeList = (DTypeList)dType;
                {
                    DType dType2;
                    entryType = dType2 = dTypeList.entryType();
                }
                object = "[" + DType.toString(entryType, false) + "]";
                return object;
            }
            case 3: {
                DType entryType;
                DTypeObject dTypeObject = (DTypeObject)dType;
                {
                    DType dType3;
                    entryType = dType3 = dTypeObject.entryType();
                }
                object = "{" + DType.toString(entryType, false) + "}";
                return object;
            }
            case 4: {
                String args;
                Object v;
                DTypeCallable dTypeCallable = (DTypeCallable)dType;
                {
                    Object object2 = dTypeCallable.from();
                    List<DTypeCallable.Arg> from = object2;
                    v = object2 = dTypeCallable.to();
                    args = from == null ? "any" : "(" + from.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ")";
                }
                object = args + " -> " + DType.toString((DType)v, true);
                return object;
            }
            case 5: {
                DTypeSum dTypeSum = (DTypeSum)dType;
                {
                    Set<DType> set;
                    Set<DType> elements = set = dTypeSum.elements();
                    object = (wrapComplex ? "<" : "") + elements.stream().map(s -> DType.toString(s, true)).collect(Collectors.joining(" | ")) + (wrapComplex ? ">" : "");
                }
                return object;
            }
            case 6: 
        }
        DTypeAnd dTypeAnd = (DTypeAnd)dType;
        {
            Set<DType> set;
            Set<DType> elements = set = dTypeAnd.elements();
            object = (wrapComplex ? "<" : "") + elements.stream().map(s -> DType.toString(s, true)).collect(Collectors.joining(" & ")) + (wrapComplex ? ">" : "");
        }
        return object;
    }
}

