/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.dynamic;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.muscript.core.IDynamic;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DCallable;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.DynamicBase;
import io.gitlab.jfronny.muscript.data.dynamic.DynamicTypeConversionException;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DStringLens;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeAnd;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Dynamic
extends IDynamic
permits DBool, DCallable, DList, DNull, DNumber, DObject, DString, DynamicBase {
    public static boolean isNull(Dynamic dynamic) {
        return dynamic == null || dynamic instanceof DNull;
    }

    @NotNull
    public static Dynamic fromNullable(@Nullable Dynamic dynamic) {
        return dynamic == null ? new DNull() : dynamic;
    }

    public Object getValue();

    default public boolean isBool() {
        return this instanceof DBool;
    }

    default public DBool asBool() {
        Dynamic dynamic = this;
        if (dynamic instanceof DBool) {
            DBool bool = (DBool)dynamic;
            return bool;
        }
        throw new DynamicTypeConversionException("bool", this);
    }

    default public boolean isNumber() {
        return this instanceof DNumber;
    }

    default public DNumber asNumber() {
        Dynamic dynamic = this;
        if (dynamic instanceof DNumber) {
            DNumber number = (DNumber)dynamic;
            return number;
        }
        throw new DynamicTypeConversionException("number", this);
    }

    default public boolean isString() {
        return this instanceof DString;
    }

    default public DString asString() {
        Dynamic dynamic = this;
        if (dynamic instanceof DString) {
            DString string = (DString)dynamic;
            return string;
        }
        return new DStringLens(this, () -> StringFormatter.toString((Object)this.getValue()));
    }

    default public boolean isObject() {
        return this instanceof DObject;
    }

    default public DObject asObject() {
        Dynamic dynamic = this;
        if (dynamic instanceof DObject) {
            DObject object = (DObject)dynamic;
            return object;
        }
        throw new DynamicTypeConversionException("object", this);
    }

    default public boolean isList() {
        return this instanceof DList;
    }

    default public DList asList() {
        Dynamic dynamic = this;
        if (dynamic instanceof DList) {
            DList list = (DList)dynamic;
            return list;
        }
        throw new DynamicTypeConversionException("list", this);
    }

    default public boolean isCallable() {
        return this instanceof DCallable;
    }

    default public DCallable asCallable() {
        Dynamic dynamic = this;
        if (dynamic instanceof DCallable) {
            DCallable callable = (DCallable)dynamic;
            return callable;
        }
        throw new DynamicTypeConversionException("callable", this);
    }

    default public DType getSignature() {
        HashSet<DType> variants = new HashSet<DType>();
        if (this.isBool()) {
            variants.add(DTypePrimitive.BOOL);
        }
        if (this.isNumber()) {
            variants.add(DTypePrimitive.NUMBER);
        }
        if (this.isString()) {
            variants.add(DTypePrimitive.STRING);
        }
        if (this.isObject()) {
            variants.add(new DTypeObject(null));
        }
        if (this.isList()) {
            variants.add(new DTypeList(null));
        }
        if (this.isCallable()) {
            variants.add(new DTypeCallable(null, null));
        }
        return variants.size() == 1 ? (DType)variants.stream().findFirst().orElseThrow() : new DTypeAnd(variants);
    }
}

