/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional.libs;

import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.data.additional.DCallableObject;
import io.gitlab.jfronny.muscript.data.additional.DDate;
import io.gitlab.jfronny.muscript.data.additional.DEmpty;
import io.gitlab.jfronny.muscript.data.additional.DEnum;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.DTime;
import io.gitlab.jfronny.muscript.data.additional.DataExprMapper;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.additional.libs.IntentionalException;
import io.gitlab.jfronny.muscript.data.additional.libs.SignatureDesyncException;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DCallable;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.type.DSL;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class StandardLib {
    private static final Random rnd = new Random();
    private static final DType round = DSL.callable(DSL.NUMBER, DSL.arg("number", DSL.NUMBER)).and(DSL.callable(DSL.NUMBER, DSL.arg("number", DSL.NUMBER), DSL.arg("decimalPlace", DSL.NUMBER)));
    private static final DType floor = DSL.callable(DSL.NUMBER, DSL.arg("number", DSL.NUMBER));
    private static final DType ceil = DSL.callable(DSL.NUMBER, DSL.arg("number", DSL.NUMBER));
    private static final DType abs = DSL.callable(DSL.NUMBER, DSL.arg("number", DSL.NUMBER));
    private static final DType random = DSL.callable(DSL.NUMBER, new DTypeCallable.Arg[0]).and(DSL.callable(DSL.NUMBER, DSL.arg("min", DSL.NUMBER), DSL.arg("max", DSL.NUMBER))).and(DSL.callable(DSL.generic(0), DSL.arg("in", DSL.list(DSL.generic(0))))).and(DSL.callable(DSL.object(DSL.generic(0)), DSL.arg("in", DSL.object(DSL.generic(0)))));
    private static final DType toUpper = DSL.callable(DSL.STRING, DSL.arg("from", DSL.STRING));
    private static final DType toLower = DSL.callable(DSL.STRING, DSL.arg("from", DSL.STRING));
    private static final DType contains = DSL.callable(DSL.BOOL, DSL.arg("search", DSL.list(DSL.generic(0))), DSL.arg("entry", DSL.generic(0))).and(DSL.callable(DSL.BOOL, DSL.arg("search", DSL.object(null)), DSL.arg("key", DSL.STRING))).and(DSL.callable(DSL.BOOL, DSL.arg("search", DSL.STRING), DSL.arg("substring", DSL.STRING)));
    private static final DType replace = DSL.callable(DSL.STRING, DSL.arg("in", DSL.STRING), DSL.arg("target", DSL.STRING), DSL.arg("replacement", DSL.STRING));
    private static final DType listOf = DSL.callable(DSL.list(DSL.generic(0)), DSL.arg("entries", DSL.generic(0), true));
    private static final DType len = DSL.callable(DSL.NUMBER, DSL.arg("of", DSL.STRING.or(DSL.object(null)).or(DSL.list(null))));
    private static final DType isEmpty = DSL.callable(DSL.BOOL, DSL.arg("collection", DSL.object(null).or(DSL.list(null)).or(DSL.STRING)));
    private static final DType concat = DSL.callable(DSL.list(DSL.generic(0)), DSL.arg("lists", DSL.list(DSL.generic(0)), true)).and(DSL.callable(DSL.object(DSL.generic(0)), DSL.arg("objects", DSL.generic(0), true)));
    private static final DType filter = DSL.callable(DSL.list(DSL.generic(0)), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("current", DSL.generic(0))))).and(DSL.callable(DSL.object(DSL.generic(0)), DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("key", DSL.STRING), DSL.arg("value", DSL.generic(0))))));
    private static final DType allMatch = DSL.callable(DSL.BOOL, DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("current", DSL.generic(0))))).and(DSL.callable(DSL.BOOL, DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("key", DSL.STRING), DSL.arg("value", DSL.STRING)))));
    private static final DType anyMatch = DSL.callable(DSL.BOOL, DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("current", DSL.generic(0))))).and(DSL.callable(DSL.BOOL, DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("predicate", DSL.callable(DSL.BOOL, DSL.arg("key", DSL.STRING), DSL.arg("value", DSL.STRING)))));
    private static final DType map = DSL.callable(DSL.list(DSL.generic(1)), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("mapper", DSL.callable(DSL.generic(1), DSL.arg("value", DSL.generic(0))))).and(DSL.callable(DSL.object(DSL.generic(1)), DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("mapper", DSL.callable(DSL.generic(1), DSL.arg("key", DSL.STRING), DSL.arg("value", DSL.generic(0))))));
    private static final DType flatMap = DSL.callable(DSL.list(DSL.generic(1)), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("mapper", DSL.callable(DSL.list(DSL.generic(1)), DSL.arg("value", DSL.generic(0))))).and(DSL.callable(DSL.object(DSL.generic(1)), DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("mapper", DSL.callable(DSL.object(DSL.generic(1)), DSL.arg("key", DSL.STRING), DSL.arg("value", DSL.generic(0))))));
    private static final DType fold = DSL.callable(DSL.generic(1), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("identity", DSL.generic(1)), DSL.arg("accumulator", DSL.callable(DSL.generic(1), DSL.arg("previous", DSL.generic(1)), DSL.arg("current", DSL.generic(0)))));
    private static final DType forEach = DSL.callable(DSL.generic(1), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("operation", DSL.callable(DSL.generic(1), DSL.arg("item", DSL.generic(0)))));
    private static final DType toObject = DSL.callable(DSL.object(DSL.generic(1)), DSL.arg("list", DSL.list(DSL.generic(0))), DSL.arg("keyMapper", DSL.callable(DSL.STRING, DSL.arg("item", DSL.generic(0)))), DSL.arg("valueMapper", DSL.callable(DSL.generic(1), DSL.arg("item", DSL.generic(0)))));
    private static final DType callableObject = DSL.callable(DSL.object(DSL.generic(0)).and(DSL.callable(null, (DType)null)), DSL.arg("object", DSL.object(DSL.generic(0))), DSL.arg("callable", DSL.callable(null, (DType)null)));
    private static final DType enumRepr = DSL.object(DSL.generic(0)).and(DSL.list(DSL.generic(0))).and(DSL.STRING);
    private static final DType enum_ = DSL.callable(enumRepr, DSL.arg("content", DSL.object(DSL.generic(0)))).and(DSL.callable(enumRepr.and(DSL.NUMBER), DSL.arg("content", DSL.object(DSL.generic(0))), DSL.arg("selectedKey", DSL.STRING)));
    private static final DType keys = DSL.callable(DSL.list(DSL.STRING), DSL.arg("object", DSL.object(null)));
    private static final DType values = DSL.callable(DSL.list(DSL.generic(0)), DSL.arg("object", DSL.object(DSL.generic(0))));
    private static final DType try_ = DSL.callable(DSL.object(null), DSL.arg("block", DSL.callable(null, DSL.arg("args", null, true))), DSL.arg("args", null, true));
    private static final DType fail = DSL.callable(null, DSL.arg("message", DSL.STRING)).and(DSL.callable(null, new DTypeCallable.Arg[0]));
    private static final DType sin = DSL.callable(DSL.NUMBER, DSL.arg("radians", DSL.NUMBER));
    private static final DType cos = DSL.callable(DSL.NUMBER, DSL.arg("radians", DSL.NUMBER));
    private static final DType tan = DSL.callable(DSL.NUMBER, DSL.arg("radians", DSL.NUMBER));
    private static final DType asin = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType acos = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType atan = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType atan2 = DSL.callable(DSL.NUMBER, DSL.arg("y", DSL.NUMBER), DSL.arg("x", DSL.NUMBER));
    private static final DType pow = DSL.callable(DSL.NUMBER, DSL.arg("base", DSL.NUMBER), DSL.arg("exponent", DSL.NUMBER));
    private static final DType sqrt = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType cbrt = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType log = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType log10 = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType log2 = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));
    private static final DType exp = DSL.callable(DSL.NUMBER, DSL.arg("value", DSL.NUMBER));

    public static Scope createScope(MuScriptVersion version) {
        return StandardLib.addTo(version, new Scope());
    }

    public static Scope addTo(MuScriptVersion version, Scope scope) {
        if (version.contains(MuScriptVersion.V1)) {
            scope.set("PI", Math.PI).set("E", Math.E).set("date", new DCallableObject(Map.of("today", new DDate(LocalDate::now)), DSL.object(DDate.SIGNATURE), DFinal.of(DSL.callable(DDate.SIGNATURE, DSL.arg("epochDay", DSL.NUMBER)).and(DSL.callable(DDate.SIGNATURE, DSL.arg("year", DSL.NUMBER), DSL.arg("month", DSL.NUMBER), DSL.arg("day", DSL.NUMBER))), args -> {
                if (args.size() == 1) {
                    return new DDate(() -> LocalDate.ofEpochDay(args.get(0).asNumber().getValue().longValue()));
                }
                if (args.size() != 3) {
                    throw new SignatureDesyncException("date");
                }
                int a0 = args.get(0).asNumber().getValue().intValue();
                int a1 = args.get(1).asNumber().getValue().intValue();
                int a2 = args.get(2).asNumber().getValue().intValue();
                return new DDate(() -> LocalDate.of(a0, a1, a2));
            }, "date"))).set("time", new DCallableObject(Map.of("now", new DTime(LocalTime::now)), DSL.object(DTime.SIGNATURE), DFinal.of(DSL.callable(DTime.SIGNATURE, DSL.arg("secondOfDay", DSL.NUMBER)).and(DSL.callable(DTime.SIGNATURE, DSL.arg("hour", DSL.NUMBER), DSL.arg("minute", DSL.NUMBER), DSL.arg("second", DSL.NUMBER))), args -> {
                if (args.size() == 1) {
                    return new DTime(() -> LocalTime.ofSecondOfDay(args.get(0).asNumber().getValue().intValue()));
                }
                if (args.size() != 3) {
                    throw new SignatureDesyncException("time");
                }
                int a0 = args.get(0).asNumber().getValue().intValue();
                int a1 = args.get(1).asNumber().getValue().intValue();
                int a2 = args.get(2).asNumber().getValue().intValue();
                return new DTime(() -> LocalTime.of(a0, a1, a2));
            }, "time"))).set("round", round, StandardLib::round).set("floor", floor, StandardLib::floor).set("ceil", ceil, StandardLib::ceil).set("abs", abs, StandardLib::abs).set("random", random, StandardLib::random).set("toUpper", toUpper, StandardLib::toUpper).set("toLower", toLower, StandardLib::toLower).set("contains", contains, StandardLib::contains).set("replace", replace, StandardLib::replace);
        }
        if (version.contains(MuScriptVersion.V2)) {
            scope.set("listOf", listOf, StandardLib::listOf).set("len", len, StandardLib::len).set("isEmpty", isEmpty, StandardLib::isEmpty).set("concat", concat, StandardLib::concat).set("filter", filter, StandardLib::filter).set("allMatch", allMatch, StandardLib::allMatch).set("anyMatch", anyMatch, StandardLib::anyMatch).set("map", map, StandardLib::map).set("flatMap", flatMap, StandardLib::flatMap).set("fold", fold, StandardLib::fold).set("forEach", forEach, StandardLib::forEach).set("toObject", toObject, StandardLib::toObject).set("callableObject", callableObject, StandardLib::callableObject).set("enum", enum_, StandardLib::enum_).set("keys", keys, StandardLib::keys).set("values", values, StandardLib::values).set("fail", fail, StandardLib::fail).set("try", try_, StandardLib::try_);
        }
        if (version.contains(MuScriptVersion.V4)) {
            scope.set("sin", sin, StandardLib::sin).set("cos", cos, StandardLib::cos).set("tan", tan, StandardLib::tan).set("asin", asin, StandardLib::asin).set("acos", acos, StandardLib::acos).set("atan", atan, StandardLib::atan).set("atan2", atan2, StandardLib::atan2).set("pow", pow, StandardLib::pow).set("sqrt", sqrt, StandardLib::sqrt).set("cbrt", cbrt, StandardLib::cbrt).set("log", log, StandardLib::log).set("log10", log10, StandardLib::log10).set("log2", log2, StandardLib::log2).set("exp", exp, StandardLib::exp);
        }
        return scope;
    }

    public static Map<String, String> printSignatures(MuScriptVersion version) {
        return StandardLib.createScope(version).getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ((Dynamic)s.getValue()).getSignature().toString()));
    }

    public static void main(String[] args) {
        System.out.println(StandardLib.printSignatures(MuScriptVersion.DEFAULT).entrySet().stream().map(s -> (String)s.getKey() + ": " + (String)s.getValue()).collect(Collectors.joining("\n")));
    }

    public static DNumber round(DList args) {
        return switch (args.size()) {
            case 1 -> DFinal.of(Math.round(args.get(0).asNumber().getValue()));
            case 2 -> {
                double x = Math.pow(10.0, (int)args.get(1).asNumber().getValue().doubleValue());
                yield DFinal.of((double)Math.round(args.get(0).asNumber().getValue() * x) / x);
            }
            default -> throw new SignatureDesyncException("round");
        };
    }

    public static DNumber floor(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("floor");
        }
        return DFinal.of(Math.floor(args.get(0).asNumber().getValue()));
    }

    public static DNumber ceil(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("ceil");
        }
        return DFinal.of(Math.ceil(args.get(0).asNumber().getValue()));
    }

    public static DNumber abs(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("abs");
        }
        return DFinal.of(Math.abs(args.get(0).asNumber().getValue()));
    }

    public static Dynamic random(DList args) {
        return switch (args.size()) {
            case 0 -> DFinal.of(rnd.nextDouble());
            case 2 -> {
                double min = args.get(0).asNumber().getValue();
                double max = args.get(1).asNumber().getValue();
                yield DFinal.of(min + (max - min) * rnd.nextDouble());
            }
            case 1 -> {
                if (args.get(0).isList()) {
                    Object list = args.get(0).asList().getValue();
                    yield (Dynamic)list.get(rnd.nextInt(list.size()));
                }
                if (args.get(0).isObject()) {
                    List list = List.copyOf(args.get(0).asObject().getValue().entrySet());
                    yield StandardLib.objectRepresentation(list.get(rnd.nextInt(list.size())));
                }
                throw new SignatureDesyncException("random");
            }
            default -> throw new SignatureDesyncException("random");
        };
    }

    public static DString toUpper(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("toUpper");
        }
        return DFinal.of(args.get(0).asString().getValue().toUpperCase());
    }

    public static DString toLower(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("toLower");
        }
        return DFinal.of(args.get(0).asString().getValue().toLowerCase());
    }

    public static DBool contains(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("contains");
        }
        Dynamic arg0 = args.get(0);
        Dynamic arg1 = args.get(1);
        boolean contained = false;
        contained |= arg0.isList() && arg0.asList().getValue().contains(arg1);
        contained |= arg0.isObject() && arg0.asObject().getValue().containsKey(arg1.asString().getValue());
        return DFinal.of(contained |= arg0.isString() && arg0.asString().getValue().contains(arg1.asString().getValue()));
    }

    public static DString replace(DList args) {
        if (args.size() != 3) {
            throw new SignatureDesyncException("replace");
        }
        return DFinal.of(args.get(0).asString().getValue().replace(args.get(1).asString().getValue(), args.get(2).asString().getValue()));
    }

    public static DList listOf(DList args) {
        return args;
    }

    public static DNumber len(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("len");
        }
        Dynamic arg0 = args.get(0);
        if (arg0.isString()) {
            return DFinal.of(arg0.asString().getValue().length());
        }
        if (arg0.isObject()) {
            return DFinal.of(arg0.asObject().getValue().size());
        }
        if (arg0.isList()) {
            return DFinal.of(arg0.asList().size());
        }
        throw new SignatureDesyncException("len");
    }

    public static DBool isEmpty(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("isEmpty");
        }
        Dynamic arg0 = args.get(0);
        if (arg0.isObject()) {
            return DFinal.of(arg0.asObject().getValue().isEmpty());
        }
        if (arg0.isList()) {
            return DFinal.of(arg0.asList().isEmpty());
        }
        if (arg0.isString()) {
            return DFinal.of(arg0.asString().getValue().isEmpty());
        }
        throw new SignatureDesyncException("isEmpty");
    }

    public static Dynamic concat(DList args) {
        if (args.isEmpty()) {
            return DEmpty.INSTANCE;
        }
        if (args.get(0).isList()) {
            return DFinal.of(args.getValue().stream().flatMap(s -> s.asList().getValue().stream()).toList());
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.getValue().stream().flatMap(s -> s.asObject().getValue().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        throw new SignatureDesyncException("concat");
    }

    public static Dynamic filter(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("filter");
        }
        DCallable dc = args.get(1).asCallable();
        if (args.get(0).isList()) {
            return DFinal.of(args.get(0).asList().getValue().stream().filter(a -> dc.call((Dynamic)a).asBool().getValue()).toList());
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.get(0).asObject().getValue().entrySet().stream().filter(entry -> dc.call(DFinal.of((String)entry.getKey()), (Dynamic)entry.getValue()).asBool().getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        throw new SignatureDesyncException("filter");
    }

    public static DBool allMatch(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("allMatch");
        }
        DCallable dc = args.get(1).asCallable();
        if (args.get(0).isList()) {
            return DFinal.of(args.get(0).asList().getValue().stream().allMatch(a -> dc.call((Dynamic)a).asBool().getValue()));
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.get(0).asObject().getValue().entrySet().stream().allMatch(a -> dc.call(DFinal.of((String)a.getKey()), (Dynamic)a.getValue()).asBool().getValue()));
        }
        throw new SignatureDesyncException("allMatch");
    }

    public static DBool anyMatch(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("anyMatch");
        }
        DCallable dc = args.get(1).asCallable();
        if (args.get(0).isList()) {
            return DFinal.of(args.get(0).asList().getValue().stream().anyMatch(a -> dc.call((Dynamic)a).asBool().getValue()));
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.get(0).asObject().getValue().entrySet().stream().anyMatch(a -> dc.call(DFinal.of((String)a.getKey()), (Dynamic)a.getValue()).asBool().getValue()));
        }
        throw new SignatureDesyncException("anyMatch");
    }

    public static Dynamic map(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("map");
        }
        DCallable dc = args.get(1).asCallable();
        if (args.get(0).isList()) {
            return DFinal.of(args.get(0).asList().getValue().stream().map(xva$0 -> dc.call((Dynamic)xva$0)).toList());
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.get(0).asObject().getValue().entrySet().stream().map(e -> new Entry((String)e.getKey(), dc.call(DFinal.of((String)e.getKey()), (Dynamic)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        throw new SignatureDesyncException("map");
    }

    public static Dynamic flatMap(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("flatMap");
        }
        DCallable dc = args.get(1).asCallable();
        if (args.get(0).isList()) {
            return DFinal.of(args.get(0).asList().getValue().stream().flatMap(a -> dc.call((Dynamic)a).asList().getValue().stream()).toList());
        }
        if (args.get(0).isObject()) {
            return DFinal.of(args.get(0).asObject().getValue().entrySet().stream().flatMap(e -> dc.call(DFinal.of((String)e.getKey()), (Dynamic)e.getValue()).asObject().getValue().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        throw new SignatureDesyncException("flatMap");
    }

    public static Dynamic fold(DList args) {
        if (args.size() != 3) {
            throw new SignatureDesyncException("fold");
        }
        return args.get(0).asList().getValue().stream().map(Function.identity()).reduce(args.get(1), (arg_0, arg_1) -> StandardLib.lambda$fold$20(args.get(2).asCallable(), arg_0, arg_1));
    }

    public static Dynamic forEach(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("forEach");
        }
        Dynamic result = new DNull();
        DCallable dc = args.get(1).asCallable();
        Iterator iterator = args.get(0).asList().getValue().iterator();
        while (iterator.hasNext()) {
            Dynamic dynamic = (Dynamic)iterator.next();
            result = dc.call(dynamic);
        }
        return result;
    }

    public static DObject toObject(DList args) {
        if (args.size() != 3) {
            throw new SignatureDesyncException("toObject");
        }
        DCallable keyMapper = args.get(1).asCallable();
        DCallable valueMapper = args.get(2).asCallable();
        return DFinal.of(args.get(0).asList().getValue().stream().collect(Collectors.toMap(a -> keyMapper.call((Dynamic)a).asString().getValue(), xva$0 -> valueMapper.call((Dynamic)xva$0), (a, b) -> b, LinkedHashMap::new)));
    }

    public static DCallableObject callableObject(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("callableObject");
        }
        return new DCallableObject((Map<String, ? extends Dynamic>)args.get(0).asObject().getValue(), args.get(1).asCallable());
    }

    public static DEnum enum_(DList args) {
        if (args.size() == 1) {
            return new DEnum((Map<String, ? extends Dynamic>)args.get(0).asObject().getValue());
        }
        if (args.size() == 2) {
            return new DEnum((Map<String, ? extends Dynamic>)args.get(0).asObject().getValue(), args.get(1).asString().getValue());
        }
        throw new SignatureDesyncException("enum");
    }

    public static DList keys(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("keys");
        }
        return DFinal.of(args.get(0).asObject().getValue().keySet().stream().map(DFinal::of).toList());
    }

    public static DList values(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("values");
        }
        return DFinal.of(args.get(0).asObject().getValue().values().stream().toList());
    }

    public static DObject try_(DList args) {
        if (args.isEmpty()) {
            throw new SignatureDesyncException("try");
        }
        DCallable callable = args.get(0).asCallable();
        Object l = args.getValue();
        DList innerArgs = DFinal.of(l.subList(1, l.size()));
        Supplier<Expr> serializedCatch = () -> new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "call"), args.getValue().stream().map(a -> new Call.Argument(ExprUtils.asDynamic(DataExprMapper.map(a)), false)).toList());
        try {
            Dynamic result = callable.call(innerArgs);
            return DFinal.of(Map.of("result", result, "catch", DFinal.of("catch", param -> {
                if (param.size() != 1) {
                    throw new SignatureDesyncException("catch");
                }
                param.get(0).asCallable();
                return DFinal.of(Map.of("result", result));
            }, serializedCatch)));
        }
        catch (LocationalException le) {
            return DFinal.of(Map.of("result", new DNull(), "catch", DFinal.of("catch", param -> {
                if (param.size() != 1) {
                    throw new SignatureDesyncException("catch");
                }
                Dynamic result = param.get(0).asCallable().call(DFinal.of(Map.of("message", DFinal.of(le.getMessage()))));
                return DFinal.of(Map.of("result", result));
            }, serializedCatch)));
        }
    }

    public static DNull fail(DList args) {
        if (args.size() > 1) {
            throw new SignatureDesyncException("fail");
        }
        throw new IntentionalException(args.isEmpty() ? "Failed" : args.get(0).asString().getValue());
    }

    public static DNumber sin(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("sin");
        }
        return DFinal.of(Math.sin(args.get(0).asNumber().getValue()));
    }

    public static DNumber cos(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("cos");
        }
        return DFinal.of(Math.cos(args.get(0).asNumber().getValue()));
    }

    public static DNumber tan(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("tan");
        }
        return DFinal.of(Math.tan(args.get(0).asNumber().getValue()));
    }

    public static DNumber asin(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("asin");
        }
        return DFinal.of(Math.asin(args.get(0).asNumber().getValue()));
    }

    public static DNumber acos(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("acos");
        }
        return DFinal.of(Math.acos(args.get(0).asNumber().getValue()));
    }

    public static DNumber atan(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("atan");
        }
        return DFinal.of(Math.atan(args.get(0).asNumber().getValue()));
    }

    public static DNumber atan2(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("atan2");
        }
        return DFinal.of(Math.atan2(args.get(0).asNumber().getValue(), args.get(1).asNumber().getValue()));
    }

    public static DNumber pow(DList args) {
        if (args.size() != 2) {
            throw new SignatureDesyncException("pow");
        }
        return DFinal.of(Math.pow(args.get(0).asNumber().getValue(), args.get(1).asNumber().getValue()));
    }

    public static DNumber sqrt(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("sqrt");
        }
        return DFinal.of(Math.sqrt(args.get(0).asNumber().getValue()));
    }

    public static DNumber cbrt(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("cbrt");
        }
        return DFinal.of(Math.cbrt(args.get(0).asNumber().getValue()));
    }

    public static DNumber log(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("log");
        }
        return DFinal.of(Math.log(args.get(0).asNumber().getValue()));
    }

    public static DNumber log10(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("log10");
        }
        return DFinal.of(Math.log10(args.get(0).asNumber().getValue()));
    }

    public static DNumber log2(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("log2");
        }
        return DFinal.of(Math.log(args.get(0).asNumber().getValue()) / Math.log(2.0));
    }

    public static DNumber exp(DList args) {
        if (args.size() != 1) {
            throw new SignatureDesyncException("exp");
        }
        return DFinal.of(Math.exp(args.get(0).asNumber().getValue()));
    }

    public static DObject objectRepresentation(Map.Entry<String, ? extends Dynamic> entry) {
        return StandardLib.objectRepresentation(entry.getKey(), entry.getValue());
    }

    public static DObject objectRepresentation(String key, Dynamic value) {
        return DFinal.of(Map.of("key", DFinal.of(key), "value", value));
    }

    private static /* synthetic */ Dynamic lambda$fold$20(DCallable rec$, Dynamic xva$0, Dynamic xva$1) {
        return rec$.call(xva$0, xva$1);
    }

    record Entry(String key, Dynamic value) implements Map.Entry<String, Dynamic>
    {
        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Dynamic getValue() {
            return this.value;
        }

        @Override
        public Dynamic setValue(Dynamic value) {
            throw new UnsupportedOperationException();
        }
    }
}

