/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional.libs;

import io.gitlab.jfronny.muscript.ast.context.IExprParser;
import io.gitlab.jfronny.muscript.ast.context.Script;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.core.SourceFS;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface IOWrapper {
    public String readString(String var1);

    public Script parseScript(String var1);

    public static class SourceFSWrapper
    implements IOWrapper {
        private final SourceFS inner;
        private final MuScriptVersion version;

        public SourceFSWrapper(MuScriptVersion version, SourceFS inner) {
            this.inner = Objects.requireNonNull(inner);
            this.version = Objects.requireNonNull(version);
        }

        @Override
        public String readString(String path) {
            return this.inner.read(path);
        }

        @Override
        public Script parseScript(String path) {
            return IExprParser.INSTANCE.parseMultiScript(this.version, path, this.inner);
        }
    }

    public static class Caching
    implements IOWrapper {
        private final Map<String, String> cachedStrings = new HashMap<String, String>();
        private final Map<String, Script> cachedScripts = new HashMap<String, Script>();
        private final IOWrapper inner;

        public Caching(IOWrapper inner) {
            this.inner = Objects.requireNonNull(inner);
        }

        @Override
        public String readString(String path) {
            return this.cachedStrings.computeIfAbsent(path, this.inner::readString);
        }

        @Override
        public Script parseScript(String path) {
            return this.cachedScripts.computeIfAbsent(path, this.inner::parseScript);
        }
    }
}

