/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional.impl;

import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.NullLiteral;
import io.gitlab.jfronny.muscript.ast.bool.BoolLiteral;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.dynamic.Bind;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.ObjectLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.ast.number.NumberLiteral;
import io.gitlab.jfronny.muscript.ast.string.StringLiteral;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.data.additional.DCallableObject;
import io.gitlab.jfronny.muscript.data.additional.DDate;
import io.gitlab.jfronny.muscript.data.additional.DEnum;
import io.gitlab.jfronny.muscript.data.additional.DTime;
import io.gitlab.jfronny.muscript.data.additional.DataExprMapper;
import io.gitlab.jfronny.muscript.data.additional.DelegateDynamic;
import io.gitlab.jfronny.muscript.data.additional.context.DynamicBasePlus;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DCallable;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.NamedDCallable;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DLens;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class DataExprMappingDefault
implements DataExprMapper.Mapping {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Expr map(Dynamic dynamic) {
        Dynamic dynamic2 = dynamic;
        Objects.requireNonNull(dynamic2);
        Dynamic dynamic3 = dynamic2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicBasePlus.class, DLens.class, DCallableObject.class, DDate.class, DTime.class, DEnum.class, NamedDCallable.class, DelegateDynamic.class, DBool.class, DList.class, DNull.class, DNumber.class, DObject.class, DString.class}, (Object)dynamic3, n)) {
            case 0: {
                DynamicBasePlus base = (DynamicBasePlus)dynamic3;
                Expr expr = base.toExpr();
                return expr;
            }
            case 1: {
                DLens lens = (DLens)dynamic3;
                Expr expr = DataExprMapper.map(lens.getSource());
                return expr;
            }
            case 2: {
                DCallableObject dco = (DCallableObject)dynamic3;
                Expr expr = new Call(CodeLocation.NONE, new Bind(CodeLocation.NONE, new Variable(CodeLocation.NONE, "callableObject"), DataExprMappingDefault.convertObjectSimple(dco)), List.of(new Call.Argument(ExprUtils.asDynamic(DataExprMapper.map(dco.callable())), false)));
                return expr;
            }
            case 3: {
                DDate date = (DDate)dynamic3;
                Expr expr = new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "date"), List.of(new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, date.date().get().getYear())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, date.date().get().getMonthValue())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, date.date().get().getDayOfMonth())), false)));
                return expr;
            }
            case 4: {
                DTime time = (DTime)dynamic3;
                Expr expr = new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "time"), List.of(new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, time.time().get().getHour())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, time.time().get().getMinute())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, time.time().get().getSecond())), false)));
                return expr;
            }
            case 5: {
                DEnum enm = (DEnum)dynamic3;
                Expr expr = DataExprMappingDefault.convertEnum(enm);
                return expr;
            }
            case 6: {
                DCallable inner;
                NamedDCallable namedDCallable = (NamedDCallable)dynamic3;
                try {
                    Object object = namedDCallable.inner();
                    inner = object;
                    Object name = object = namedDCallable.name();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Expr expr = DataExprMapper.map(inner);
                return expr;
            }
            case 7: {
                DelegateDynamic delegate = (DelegateDynamic)dynamic3;
                Expr expr = DataExprMapper.map(delegate.getDelegate());
                return expr;
            }
            case 8: {
                DBool bool = (DBool)dynamic3;
                Expr expr = new BoolLiteral(CodeLocation.NONE, bool.getValue());
                return expr;
            }
            case 9: {
                DList list = (DList)dynamic3;
                Expr expr = new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "listOf"), list.getValue().stream().map((? super T s) -> new Call.Argument(ExprUtils.asDynamic(DataExprMapper.map(s)), false)).toList());
                return expr;
            }
            case 10: {
                DNull nul = (DNull)dynamic3;
                Expr expr = new NullLiteral(CodeLocation.NONE);
                return expr;
            }
            case 11: {
                DNumber number = (DNumber)dynamic3;
                Expr expr = new NumberLiteral(CodeLocation.NONE, number.getValue());
                return expr;
            }
            case 12: {
                DObject object = (DObject)dynamic3;
                Expr expr = DataExprMappingDefault.convertObjectSimple(object);
                return expr;
            }
            case 13: {
                DString string = (DString)dynamic3;
                Expr expr = new StringLiteral(CodeLocation.NONE, string.getValue());
                return expr;
            }
        }
        return null;
    }

    private static DynamicExpr convertObjectSimple(DObject object) {
        return DataExprMappingDefault.convertObjectSimple((Map<String, ? extends Dynamic>)object.getValue());
    }

    private static DynamicExpr convertObjectSimple(Map<String, ? extends Dynamic> object) {
        return new ObjectLiteral(CodeLocation.NONE, object.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ExprUtils.asDynamic(DataExprMapper.map((Dynamic)s.getValue())))));
    }

    private static DynamicExpr convertEnum(DEnum enm) {
        LinkedList<Call.Argument> args = new LinkedList<Call.Argument>();
        args.add(new Call.Argument(DataExprMappingDefault.convertObjectSimple(enm.values()), false));
        if (enm.value() != null) {
            args.add(new Call.Argument(ExprUtils.asDynamic(new StringLiteral(CodeLocation.NONE, enm.value().value())), false));
        }
        return new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "enum"), args);
    }
}

