/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional.context;

import io.gitlab.jfronny.commons.data.ImmCollection;
import io.gitlab.jfronny.muscript.ast.context.IScope;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.context.DynamicSerializer;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Scope
implements DObject,
IScope {
    @Nullable
    private final Scope source;
    private final Map<String, Dynamic> override = new HashMap<String, Dynamic>();

    public Scope() {
        this(null);
    }

    public Scope(@Nullable DObject source) {
        if (source == null) {
            this.source = null;
        } else if (source instanceof Scope) {
            Scope src;
            this.source = src = (Scope)source;
        } else {
            this.source = new Scope();
            source.getValue().forEach(this::set);
        }
    }

    public Scope(@Nullable Scope source) {
        this.source = source;
    }

    public static Scope of(DObject source) {
        Scope scope;
        return source instanceof Scope ? (scope = (Scope)source) : new Scope(source);
    }

    @Override
    public Map<String, Dynamic> getValue() {
        if (this.source == null) {
            return ImmCollection.of(this.override);
        }
        HashMap<String, Dynamic> map = new HashMap<String, Dynamic>((Map<String, Dynamic>)this.source.getValue());
        map.putAll(this.override);
        return ImmCollection.of(map);
    }

    @Deprecated(forRemoval=false)
    public Scope set(String key, Dynamic value) {
        if (key.startsWith("$")) {
            if (!this.setGlobal(key, value)) {
                this.override.put(key, value);
            }
        } else {
            this.override.put(key, value);
        }
        return this;
    }

    private boolean setGlobal(String key, Dynamic value) {
        if (this.override.containsKey(key)) {
            this.override.put(key, value);
            return true;
        }
        if (this.source != null) {
            return this.source.setGlobal(key, value);
        }
        return false;
    }

    public Scope set(String key, boolean value) {
        return this.set(key, DFinal.of(value));
    }

    public Scope set(String key, double value) {
        return this.set(key, DFinal.of(value));
    }

    public Scope set(String key, String value) {
        return this.set(key, DFinal.of(value));
    }

    public Scope set(String key, Map<String, ? extends Dynamic> value) {
        return this.set(key, DFinal.of(value));
    }

    public Scope set(String key, DTypeObject signature, Map<String, ? extends Dynamic> value) {
        return this.set(key, DFinal.of(signature, value));
    }

    public Scope set(String key, List<? extends Dynamic> value) {
        return this.set(key, DFinal.of(value));
    }

    public Scope set(String key, DTypeList signature, List<? extends Dynamic> value) {
        return this.set(key, DFinal.of(signature, value));
    }

    public Scope set(String key, Function<DList, ? extends Dynamic> value) {
        return this.set(key, DFinal.of(value, () -> key, key));
    }

    public Scope set(String key, DType signature, Function<DList, ? extends Dynamic> value) {
        return this.set(key, DFinal.of(signature, value, () -> key, key));
    }

    public Scope fork() {
        return new Scope(this);
    }

    public DObject getOverrides() {
        return DFinal.of(this.override);
    }

    public String toString() {
        return DynamicSerializer.INSTANCE.serialize(this);
    }
}

