/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.commons.data.ImmCollection;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.context.IExprParser;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.IDynamic;
import io.gitlab.jfronny.muscript.data.additional.context.DynamicBasePlus;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DCallable;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.context.DynamicSerializer;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class DFinal {
    public static DBool of(boolean b) {
        return new FBool(b);
    }

    public static DNumber of(double b) {
        return new FNumber(b);
    }

    public static DString of(String b) {
        return new FString(b);
    }

    public static DObject of(Map<String, ? extends Dynamic> b) {
        return DFinal.of(new DTypeObject(null), b);
    }

    public static DObject of(DTypeObject signature, Map<String, ? extends Dynamic> b) {
        return new FObject(ImmCollection.copyOf(b), Objects.requireNonNull(signature));
    }

    public static DList of(Dynamic ... b) {
        return DFinal.of(new DTypeList(null), b);
    }

    public static DList of(DTypeList signature, Dynamic ... b) {
        return new FList(List.of(b), Objects.requireNonNull(signature));
    }

    public static DList of(List<? extends Dynamic> b) {
        return DFinal.of(new DTypeList(null), b);
    }

    public static DList of(DTypeList signature, List<? extends Dynamic> b) {
        return new FList(ImmCollection.copyOf(b), Objects.requireNonNull(signature));
    }

    public static DCallable of(Function<DList, ? extends Dynamic> b, Supplier<String> serialized) {
        return DFinal.of((DType)new DTypeCallable(null, null), b, Objects.requireNonNull(serialized));
    }

    public static DCallable of(DType signature, Function<DList, ? extends Dynamic> b, Supplier<String> serialized) {
        return DFinal.of(Objects.requireNonNull(signature), b, serialized, null);
    }

    public static DCallable of(Function<DList, ? extends Dynamic> b, String name) {
        return DFinal.of((DType)new DTypeCallable(null, null), b, name);
    }

    public static DCallable of(DType signature, Function<DList, ? extends Dynamic> b, String name) {
        return DFinal.of(Objects.requireNonNull(signature), name, b, () -> new Variable(CodeLocation.NONE, name));
    }

    public static DCallable of(Function<DList, ? extends Dynamic> b, Supplier<String> serialized, String name) {
        return DFinal.of((DType)new DTypeCallable(null, null), b, serialized, name);
    }

    public static DCallable of(DType signature, Function<DList, ? extends Dynamic> b, Supplier<String> serialized, String name) {
        return DFinal.of(Objects.requireNonNull(signature), name, b, () -> IExprParser.INSTANCE.parse((String)serialized.get()));
    }

    public static DCallable of(String name, Function<DList, ? extends Dynamic> b, Supplier<Expr> serialized) {
        return DFinal.of((DType)new DTypeCallable(null, null), name, b, serialized);
    }

    public static DCallable of(DType signature, String name, Function<DList, ? extends Dynamic> b, Supplier<Expr> serialized) {
        return new FCallable(b, (Supplier<Expr>)new LazySupplier(serialized), name, Objects.requireNonNull(signature));
    }

    private record FBool(boolean value) implements DBool,
    FImpl
    {
        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return StringFormatter.toString((Object)this.value);
        }

        @Override
        public DType getSignature() {
            return DTypePrimitive.BOOL;
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    private record FNumber(double value) implements DNumber,
    FImpl
    {
        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return StringFormatter.toStringPrecise((double)this.value);
        }

        @Override
        public DType getSignature() {
            return DTypePrimitive.NUMBER;
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    private record FString(String value) implements DString,
    FImpl
    {
        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return DynamicSerializer.INSTANCE.serialize(this);
        }

        @Override
        public DType getSignature() {
            return DTypePrimitive.STRING;
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    private record FObject(Map<String, Dynamic> value, DTypeObject signature) implements DObject,
    FImpl
    {
        @Override
        public Map<String, Dynamic> getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return DynamicSerializer.INSTANCE.serialize(this);
        }

        @Override
        public DType getSignature() {
            return this.signature;
        }

        @Override
        public boolean isDirect() {
            return this.value.values().stream().allMatch(IDynamic::isDirect);
        }
    }

    private record FList(List<Dynamic> value, DTypeList signature) implements DList,
    FImpl
    {
        @Override
        public List<Dynamic> getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        @Override
        public DType getSignature() {
            return this.signature;
        }

        @Override
        public boolean isDirect() {
            return this.value.stream().allMatch(IDynamic::isDirect);
        }
    }

    private record FCallable(Function<DList, Dynamic> value, Supplier<Expr> gen, String name, DType signature) implements DCallable,
    FImpl,
    DynamicBasePlus
    {
        @Override
        public Expr toExpr() {
            return this.gen.get();
        }

        @Override
        public Function<DList, Dynamic> getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.toExpr().toString();
        }

        @Override
        public String getName() {
            return this.name == null ? DCallable.super.getName() : this.name;
        }

        @Override
        public DCallable named(String name) {
            return new FCallable(this.value, this.gen, name, this.signature);
        }

        @Override
        public DType getSignature() {
            return this.signature;
        }
    }

    public static sealed interface FImpl
    permits FBool, FNumber, FString, FObject, FList, FCallable {
    }
}

