/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.commons.data.ImmCollection;
import io.gitlab.jfronny.muscript.data.dynamic.DBool;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DBoolLens;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DListLens;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DNumberLens;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DStringLens;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeAnd;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeList;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeObject;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypePrimitive;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public record DEnum(Map<String, ? extends Dynamic> values, @Nullable DEnumEntry value, @Nullable DType valueSignature) implements DObject
{
    public DEnum(Map<String, ? extends Dynamic> values) {
        this(null, values);
    }

    public DEnum(DType valueSignature, Map<String, ? extends Dynamic> values) {
        this(values, null, valueSignature);
    }

    public DEnum(Map<String, ? extends Dynamic> values, @Nullable String value) {
        this(null, values, value);
    }

    public DEnum(DType valueSignature, Map<String, ? extends Dynamic> values, @Nullable String value) {
        this(values, value == null ? null : new DEnumEntry(value, values.keySet().stream().toList().indexOf(value), true), valueSignature);
    }

    public DEnum(List<String> values, String value) {
        this(DEnum.createMap(values, value), value == null ? null : new DEnumEntry(value, values.indexOf(value), true), DTypePrimitive.STRING);
    }

    public DEnum(List<String> values) {
        this(values, null);
    }

    @Override
    public Map<String, ? extends Dynamic> getValue() {
        LinkedHashMap<String, ? extends Dynamic> result = new LinkedHashMap<String, Dynamic>(this.values);
        if (!result.containsKey("value")) {
            result.put("value", this.value);
        }
        return ImmCollection.of(result);
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public DList asList() {
        return new DListLens(this, () -> List.copyOf(this.values.values()));
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public DString asString() {
        return this.value != null ? this.value : new DStringLens(this, () -> StringFormatter.toString(this.values));
    }

    @Override
    public boolean isNumber() {
        return this.value != null;
    }

    @Override
    public DNumber asNumber() {
        return this.value != null ? new DNumberLens(this, this.value::index) : DObject.super.asNumber();
    }

    @Override
    public DType getSignature() {
        HashSet<DType> types = new HashSet<DType>();
        types.add(new DTypeObject(this.valueSignature));
        types.add(new DTypeList(this.valueSignature));
        types.add(DTypePrimitive.STRING);
        if (this.value != null) {
            types.add(DTypePrimitive.NUMBER);
        }
        return new DTypeAnd(types);
    }

    private static Map<String, Dynamic> createMap(List<String> values, String value) {
        LinkedHashMap<String, DEnumEntry> result = new LinkedHashMap<String, DEnumEntry>();
        for (int i = 0; i < values.size(); ++i) {
            result.put(values.get(i), new DEnumEntry(values.get(i), i, values.get(i).equals(value)));
        }
        return ImmCollection.of(result);
    }

    public record DEnumEntry(String value, int index, boolean selected) implements DString
    {
        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public DNumber asNumber() {
            return new DNumberLens(this, this::index);
        }

        @Override
        public boolean isBool() {
            return true;
        }

        @Override
        public DBool asBool() {
            return new DBoolLens(this, this::selected);
        }
    }
}

