/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.data.additional;

import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.ast.number.NumberLiteral;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.dynamic.DNumber;
import io.gitlab.jfronny.muscript.data.dynamic.DObject;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DNumberLens;
import io.gitlab.jfronny.muscript.data.dynamic.lens.DStringLens;
import io.gitlab.jfronny.muscript.data.dynamic.type.DSL;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public record DDate(Supplier<LocalDate> date) implements DObject
{
    public static final DType SIGNATURE = DSL.object(DSL.NUMBER).or(DSL.STRING).or(DSL.NUMBER);

    @Override
    public Map<String, Dynamic> getValue() {
        return Map.of("year", DFinal.of(this.date.get().getYear()), "month", DFinal.of(this.date.get().getMonthValue()), "day", DFinal.of(this.date.get().getDayOfMonth()));
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public DString asString() {
        return new DStringLens(this, this::toString);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public DNumber asNumber() {
        return new DNumberLens(this, () -> this.date.get().toEpochDay());
    }

    public DynamicExpr toExpr() {
        return new Call(CodeLocation.NONE, new Variable(CodeLocation.NONE, "date"), List.of(new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, this.date.get().getYear())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, this.date.get().getMonthValue())), false), new Call.Argument(ExprUtils.asDynamic(new NumberLiteral(CodeLocation.NONE, this.date.get().getDayOfMonth())), false)));
    }

    @Override
    public DType getSignature() {
        return SIGNATURE;
    }

    @Override
    public String toString() {
        return this.date.get().toString();
    }
}

