/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.core;

public sealed interface StackFrame {

    public record Lined(String file, String name, int row) implements StackFrame
    {
        @Override
        public String toString() {
            return this.name + " (call: line " + this.row + (String)(this.file == null ? ")" : " in " + this.file + ")");
        }
    }

    public record Raw(String file, String name, int chStart) implements StackFrame
    {
        @Override
        public String toString() {
            return this.name + " (call: character " + this.chStart + (String)(this.file == null ? ")" : " in " + this.file + ")");
        }

        public Lined lined(String source) {
            int lineStart = source.lastIndexOf(10, this.chStart);
            int lineIndex = lineStart > 0 ? (int)source.substring(0, lineStart).chars().filter(c -> c == 10).count() : 0;
            return new Lined(this.file, this.name, lineIndex + 1);
        }
    }
}

