/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.core;

import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.StackFrame;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public record PrettyPrintError(String message, @Nullable Location start, @Nullable Location end, List<? extends StackFrame> callStack) {
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.start == null || this.start.column < 0) {
            sb.append("Error at unknown location: ").append(this.message);
        } else {
            sb.append("Error at ").append(this.start).append(": ").append(this.message).append("\n");
            if (this.end == null) {
                sb.append(this.start.prettyPrint()).append("Here");
            } else if (this.start.row == this.end.row) {
                String linePrefix = String.format("%1$6d", this.start.row) + " | ";
                sb.append(linePrefix).append(this.start.line).append("\n").append(" ".repeat(linePrefix.length() + this.start.column)).append("^").append("-".repeat(this.end.column - this.start.column - 1)).append("^-- Here");
            } else {
                sb.append(this.start.prettyPrint()).append("From here").append(this.end.prettyPrint()).append("to here");
            }
        }
        this.callStack.forEach(frame -> sb.append("\n  at ").append(frame));
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CodeLocation location) {
        return PrettyPrintError.builder().setSource(location.source()).setLocation(location.chStart(), location.chEnd());
    }

    public record Location(String line, int column, int row) {
        public static Location create(@Nullable String source, int index) {
            if (source == null || index < 0) {
                return new Location("", -1, -1);
            }
            int lineStart = source.lastIndexOf(10, index);
            int lineEnd = source.indexOf(10, index);
            if (lineEnd == -1) {
                lineEnd = source.length();
            }
            int lineIndex = lineStart > 0 ? (int)source.substring(0, lineStart).chars().filter(c -> c == 10).count() : 0;
            int column = index - lineStart - 1;
            String line = lineStart == source.length() - 1 ? "" : source.substring(lineStart + 1, lineEnd);
            return new Location(line, column, lineIndex + 1);
        }

        @Override
        public String toString() {
            if (this.column >= this.line.length()) {
                return "character " + (this.column + 1) + " of line " + this.row;
            }
            return "'" + this.line.charAt(this.column) + "' (character " + (this.column + 1) + ")";
        }

        public String prettyPrint() {
            String linePrefix = String.format("%1$6d", this.row) + " | ";
            return linePrefix + this.line + "\n" + " ".repeat(linePrefix.length() + this.column) + "^-- ";
        }
    }

    public static class Builder {
        private String message;
        private Location start;
        @Nullable
        private Location end;
        private List<? extends StackFrame> callStack = List.of();
        private String source;

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setLocation(int chStart) {
            return this.setLocation(Location.create(this.source, chStart), null);
        }

        public Builder setLocation(int chStart, int chEnd) {
            if (chEnd == chStart) {
                return this.setLocation(chStart);
            }
            if (chEnd < chStart) {
                int a = chEnd;
                chEnd = chStart;
                chStart = a;
            }
            return this.setLocation(Location.create(this.source, chStart), Location.create(this.source, chEnd));
        }

        public Builder setLocation(Location start, Location end) {
            this.start = start;
            this.end = end;
            return this;
        }

        public Builder setCallStack(List<StackFrame> callStack) {
            this.callStack = callStack.stream().map(frame -> {
                StackFrame.Lined lined;
                return frame instanceof StackFrame.Lined ? (lined = (StackFrame.Lined)frame) : (this.source == null ? frame : ((StackFrame.Raw)frame).lined(this.source));
            }).toList();
            return this;
        }

        public PrettyPrintError build() {
            return new PrettyPrintError(this.message, this.start, this.end, this.callStack);
        }
    }
}

